/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;

public final class MessageUtils {
    private static final String DEFAULT_BUNDLE = "javax.faces.Messages";
    private static final String DETAIL_SUFFIX = "_detail";
    private static Log log = LogFactory.getLog(MessageUtils.class);

    private MessageUtils() {
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object arg) {
        return MessageUtils.getMessage(severity, messageId, new Object[]{arg}, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object[] args) {
        return MessageUtils.getMessage(severity, messageId, args, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        FacesMessage message = MessageUtils.getMessage(facesContext, messageId, args);
        message.setSeverity(severity);
        return message;
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args) {
        MessageUtils.addMessage(severity, messageId, args, null, FacesContext.getCurrentInstance());
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        MessageUtils.addMessage(severity, messageId, args, null, facesContext);
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, String forClientId) {
        MessageUtils.addMessage(severity, messageId, args, forClientId, FacesContext.getCurrentInstance());
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, String forClientId, FacesContext facesContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("adding message " + messageId + " for clientId " + forClientId));
        }
        facesContext.addMessage(forClientId, MessageUtils.getMessage(severity, messageId, args, facesContext));
    }

    public static String substituteParams(Locale locale, String msgtext, Object[] params) {
        String localizedStr = null;
        if (params == null || msgtext == null) {
            return msgtext;
        }
        StringBuffer b = new StringBuffer(100);
        if (locale != null) {
            MessageFormat mf = new MessageFormat(msgtext, locale);
            b.append(mf.format(params));
            localizedStr = b.toString();
        }
        return localizedStr;
    }

    public static FacesMessage getMessage(String messageId, Object[] params) {
        Locale locale = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return MessageUtils.getMessage(locale, messageId, params);
    }

    public static FacesMessage getMessage(Locale locale, String messageId, Object[] params) {
        String summary = null;
        String detail = null;
        String bundleName = MessageUtils.getApplication().getMessageBundle();
        ResourceBundle bundle = null;
        if (bundleName != null) {
            try {
                bundle = ResourceBundle.getBundle(bundleName, locale, ClassUtils.getCurrentLoader(bundleName));
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = ResourceBundle.getBundle(DEFAULT_BUNDLE, locale, ClassUtils.getCurrentLoader(DEFAULT_BUNDLE));
                if (bundle == null) {
                    throw new NullPointerException();
                }
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (summary == null) {
            summary = messageId;
        }
        if (bundle == null) {
            throw new NullPointerException("Unable to locate ResrouceBundle: bundle is null");
        }
        summary = MessageUtils.substituteParams(locale, summary, params);
        try {
            detail = MessageUtils.substituteParams(locale, bundle.getString(messageId + DETAIL_SUFFIX), params);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return new FacesMessage(summary, detail);
    }

    public static FacesMessage getMessage(String bundleBaseName, String messageId, Object[] params) {
        return MessageUtils.getMessage(bundleBaseName, MessageUtils.getCurrentLocale(), messageId, params);
    }

    public static Locale getCurrentLocale() {
        Locale locale;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String bundleBaseName, String messageId, Object[] params) {
        FacesMessage msg = MessageUtils.getMessage(bundleBaseName, messageId, params);
        msg.setSeverity(severity);
        return msg;
    }

    public static FacesMessage getMessage(String bundleBaseName, Locale locale, String messageId, Object[] params) {
        if (bundleBaseName == null) {
            throw new NullPointerException("Unable to locate ResrouceBundle: bundle is null");
        }
        ResourceBundle bundle = ResourceBundle.getBundle(bundleBaseName, locale);
        return MessageUtils.getMessage(bundle, messageId, params);
    }

    public static FacesMessage getMessage(ResourceBundle bundle, String messageId, Object[] params) {
        String summary = null;
        String detail = null;
        try {
            summary = bundle.getString(messageId);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (summary == null) {
            summary = messageId;
        }
        summary = MessageUtils.substituteParams(bundle.getLocale(), summary, params);
        try {
            detail = MessageUtils.substituteParams(bundle.getLocale(), bundle.getString(messageId + DETAIL_SUFFIX), params);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return new FacesMessage(summary, detail);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId) {
        return MessageUtils.getMessage(context, messageId, (Object[])null);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object[] params) {
        if (context == null || messageId == null) {
            throw new NullPointerException(" context " + context + " messageId " + messageId);
        }
        Locale locale = MessageUtils.getCurrentLocale();
        if (null == locale) {
            throw new NullPointerException(" locale " + locale);
        }
        FacesMessage message = MessageUtils.getMessage(locale, messageId, params);
        if (message != null) {
            return message;
        }
        locale = Locale.getDefault();
        return MessageUtils.getMessage(locale, messageId, params);
    }

    private static Application getApplication() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return FacesContext.getCurrentInstance().getApplication();
        }
        ApplicationFactory afactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        return afactory.getApplication();
    }
}

