/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.admin.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.nifi.admin.RepositoryUtils;
import org.apache.nifi.admin.dao.DataAccessException;
import org.apache.nifi.admin.dao.KeyDAO;
import org.apache.nifi.key.Key;

public class StandardKeyDAO
implements KeyDAO {
    private static final String SELECT_KEY_FOR_USER_BY_ID = "SELECT ID, IDENTITY, KEY FROM KEY WHERE ID = ?";
    private static final String SELECT_KEY_FOR_USER_BY_IDENTITY = "SELECT ID, IDENTITY, KEY FROM KEY WHERE IDENTITY = ?";
    private static final String INSERT_KEY = "INSERT INTO KEY (IDENTITY, KEY) VALUES (?, ?)";
    private static final String DELETE_KEYS = "DELETE FROM KEY WHERE IDENTITY = ?";
    private final Connection connection;

    public StandardKeyDAO(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Key findKeyById(int id) {
        Key key = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_KEY_FOR_USER_BY_ID);
            statement.setInt(1, id);
            rs = statement.executeQuery();
            if (rs.next()) {
                key = new Key();
                key.setId(rs.getInt("ID"));
                key.setIdentity(rs.getString("IDENTITY"));
                key.setKey(rs.getString("KEY"));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return key;
    }

    @Override
    public Key findLatestKeyByIdentity(String identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Specified identity cannot be null.");
        }
        Key key = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_KEY_FOR_USER_BY_IDENTITY);
            statement.setString(1, identity);
            rs = statement.executeQuery();
            if (rs.next()) {
                key = new Key();
                key.setId(rs.getInt("ID"));
                key.setIdentity(rs.getString("IDENTITY"));
                key.setKey(rs.getString("KEY"));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return key;
    }

    @Override
    public Key createKey(String identity) {
        ResultSet rs;
        PreparedStatement statement;
        block5: {
            statement = null;
            rs = null;
            String keyValue = UUID.randomUUID().toString();
            statement = this.connection.prepareStatement(INSERT_KEY, 1);
            statement.setString(1, identity);
            statement.setString(2, keyValue);
            int updateCount = statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (updateCount != 1 || !rs.next()) break block5;
            Key key = new Key();
            key.setId(rs.getInt(1));
            key.setIdentity(identity);
            key.setKey(keyValue);
            Key key2 = key;
            RepositoryUtils.closeQuietly(rs);
            RepositoryUtils.closeQuietly(statement);
            return key2;
        }
        try {
            try {
                throw new DataAccessException("Unable to add key for user.");
            }
            catch (SQLException sqle) {
                throw new DataAccessException(sqle);
            }
        }
        catch (Throwable throwable) {
            RepositoryUtils.closeQuietly(rs);
            RepositoryUtils.closeQuietly(statement);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteKeys(String identity) {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(DELETE_KEYS);
            statement.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
                catch (DataAccessException dae) {
                    throw dae;
                }
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(statement);
    }
}

