/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.admin.service.impl;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.admin.dao.DataAccessException;
import org.apache.nifi.admin.service.AdministrationException;
import org.apache.nifi.admin.service.KeyService;
import org.apache.nifi.admin.service.action.DeleteKeysAction;
import org.apache.nifi.admin.service.action.GetKeyByIdAction;
import org.apache.nifi.admin.service.action.GetOrCreateKeyAction;
import org.apache.nifi.admin.service.transaction.Transaction;
import org.apache.nifi.admin.service.transaction.TransactionBuilder;
import org.apache.nifi.admin.service.transaction.TransactionException;
import org.apache.nifi.key.Key;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardKeyService
implements KeyService {
    private static final Logger logger = LoggerFactory.getLogger(StandardKeyService.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private TransactionBuilder transactionBuilder;
    private NiFiProperties properties;

    @Override
    public Key getKey(int id) {
        Transaction transaction = null;
        Key key = null;
        this.readLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            GetKeyByIdAction addActions = new GetKeyByIdAction(id);
            key = transaction.execute(addActions);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.readLock.unlock();
        }
        return key;
    }

    @Override
    public Key getOrCreateKey(String identity) {
        Transaction transaction = null;
        Key key = null;
        this.writeLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            GetOrCreateKeyAction addActions = new GetOrCreateKeyAction(identity);
            key = transaction.execute(addActions);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.writeLock.unlock();
        }
        return key;
    }

    @Override
    public void deleteKey(String identity) {
        Transaction transaction = null;
        this.writeLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            DeleteKeysAction deleteKeys = new DeleteKeysAction(identity);
            transaction.execute(deleteKeys);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.writeLock.unlock();
        }
    }

    private void rollback(Transaction transaction) {
        if (transaction != null) {
            transaction.rollback();
        }
    }

    private void closeQuietly(Transaction transaction) {
        if (transaction != null) {
            try {
                transaction.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setTransactionBuilder(TransactionBuilder transactionBuilder) {
        this.transactionBuilder = transactionBuilder;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

