/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.authorization.AuthorizationAuditor;
import org.apache.nifi.authorization.AuthorizationAuditorInvocationHandler;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.AuthorizerInitializationContext;
import org.apache.nifi.authorization.AuthorizerInvocationHandler;
import org.apache.nifi.authorization.ConfigurableAccessPolicyProvider;
import org.apache.nifi.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserAndGroups;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.authorization.exception.UninheritableAuthorizationsException;

public final class AuthorizerFactory {
    private static boolean policyExists(AccessPolicyProvider accessPolicyProvider, AccessPolicy checkAccessPolicy) {
        for (AccessPolicy accessPolicy : accessPolicyProvider.getAccessPolicies()) {
            if (accessPolicy.getIdentifier().equals(checkAccessPolicy.getIdentifier()) || !accessPolicy.getResource().equals(checkAccessPolicy.getResource()) || !accessPolicy.getAction().equals((Object)checkAccessPolicy.getAction())) continue;
            return true;
        }
        return false;
    }

    private static boolean tenantExists(UserGroupProvider userGroupProvider, String identifier, String identity) {
        for (User user : userGroupProvider.getUsers()) {
            if (user.getIdentifier().equals(identifier) || !user.getIdentity().equals(identity)) continue;
            return true;
        }
        for (Group group : userGroupProvider.getGroups()) {
            if (group.getIdentifier().equals(identifier) || !group.getName().equals(identity)) continue;
            return true;
        }
        return false;
    }

    private static boolean allGroupUsersExist(UserGroupProvider userGroupProvider, Group group) {
        for (String userIdentifier : group.getUsers()) {
            User user = userGroupProvider.getUser(userIdentifier);
            if (user != null) continue;
            return false;
        }
        return true;
    }

    private static void audit(Authorizer authorizer, AuthorizationRequest request, AuthorizationResult result) {
        if (authorizer instanceof AuthorizationAuditor && request.isAccessAttempt() && !AuthorizationResult.Result.ResourceNotFound.equals((Object)result.getResult())) {
            ((AuthorizationAuditor)authorizer).auditAccessAttempt(request, result);
        }
    }

    public static Authorizer installIntegrityChecks(final Authorizer baseAuthorizer) {
        Object authorizer;
        if (baseAuthorizer instanceof ManagedAuthorizer) {
            final ManagedAuthorizer baseManagedAuthorizer = (ManagedAuthorizer)baseAuthorizer;
            authorizer = new ManagedAuthorizer(){

                public String getFingerprint() throws AuthorizationAccessException {
                    return baseManagedAuthorizer.getFingerprint();
                }

                public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
                    baseManagedAuthorizer.inheritFingerprint(fingerprint);
                }

                public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
                    baseManagedAuthorizer.checkInheritability(proposedFingerprint);
                }

                public AccessPolicyProvider getAccessPolicyProvider() {
                    AccessPolicyProvider baseAccessPolicyProvider = baseManagedAuthorizer.getAccessPolicyProvider();
                    if (baseAccessPolicyProvider instanceof ConfigurableAccessPolicyProvider) {
                        final ConfigurableAccessPolicyProvider baseConfigurableAccessPolicyProvider = (ConfigurableAccessPolicyProvider)baseAccessPolicyProvider;
                        return new ConfigurableAccessPolicyProvider(){

                            public String getFingerprint() throws AuthorizationAccessException {
                                return baseConfigurableAccessPolicyProvider.getFingerprint();
                            }

                            public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
                                baseConfigurableAccessPolicyProvider.inheritFingerprint(fingerprint);
                            }

                            public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
                                baseConfigurableAccessPolicyProvider.checkInheritability(proposedFingerprint);
                            }

                            public AccessPolicy addAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
                                if (AuthorizerFactory.policyExists((AccessPolicyProvider)baseConfigurableAccessPolicyProvider, accessPolicy)) {
                                    throw new IllegalStateException(String.format("Found multiple policies for '%s' with '%s'.", accessPolicy.getResource(), accessPolicy.getAction()));
                                }
                                return baseConfigurableAccessPolicyProvider.addAccessPolicy(accessPolicy);
                            }

                            public boolean isConfigurable(AccessPolicy accessPolicy) {
                                return baseConfigurableAccessPolicyProvider.isConfigurable(accessPolicy);
                            }

                            public AccessPolicy updateAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
                                if (!baseConfigurableAccessPolicyProvider.isConfigurable(accessPolicy)) {
                                    throw new IllegalArgumentException("The specified access policy is not support modification.");
                                }
                                return baseConfigurableAccessPolicyProvider.updateAccessPolicy(accessPolicy);
                            }

                            public AccessPolicy deleteAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
                                if (!baseConfigurableAccessPolicyProvider.isConfigurable(accessPolicy)) {
                                    throw new IllegalArgumentException("The specified access policy is not support modification.");
                                }
                                return baseConfigurableAccessPolicyProvider.deleteAccessPolicy(accessPolicy);
                            }

                            public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
                                return baseConfigurableAccessPolicyProvider.getAccessPolicies();
                            }

                            public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
                                return baseConfigurableAccessPolicyProvider.getAccessPolicy(identifier);
                            }

                            public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) throws AuthorizationAccessException {
                                return baseConfigurableAccessPolicyProvider.getAccessPolicy(resourceIdentifier, action);
                            }

                            public UserGroupProvider getUserGroupProvider() {
                                UserGroupProvider baseUserGroupProvider = baseConfigurableAccessPolicyProvider.getUserGroupProvider();
                                if (baseUserGroupProvider instanceof ConfigurableUserGroupProvider) {
                                    final ConfigurableUserGroupProvider baseConfigurableUserGroupProvider = (ConfigurableUserGroupProvider)baseUserGroupProvider;
                                    return new ConfigurableUserGroupProvider(){

                                        public String getFingerprint() throws AuthorizationAccessException {
                                            return baseConfigurableUserGroupProvider.getFingerprint();
                                        }

                                        public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
                                            baseConfigurableUserGroupProvider.inheritFingerprint(fingerprint);
                                        }

                                        public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
                                            baseConfigurableUserGroupProvider.checkInheritability(proposedFingerprint);
                                        }

                                        public User addUser(User user) throws AuthorizationAccessException {
                                            if (AuthorizerFactory.tenantExists((UserGroupProvider)baseConfigurableUserGroupProvider, user.getIdentifier(), user.getIdentity())) {
                                                throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", user.getIdentity()));
                                            }
                                            return baseConfigurableUserGroupProvider.addUser(user);
                                        }

                                        public boolean isConfigurable(User user) {
                                            return baseConfigurableUserGroupProvider.isConfigurable(user);
                                        }

                                        public User updateUser(User user) throws AuthorizationAccessException {
                                            if (AuthorizerFactory.tenantExists((UserGroupProvider)baseConfigurableUserGroupProvider, user.getIdentifier(), user.getIdentity())) {
                                                throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", user.getIdentity()));
                                            }
                                            if (!baseConfigurableUserGroupProvider.isConfigurable(user)) {
                                                throw new IllegalArgumentException("The specified user does not support modification.");
                                            }
                                            return baseConfigurableUserGroupProvider.updateUser(user);
                                        }

                                        public User deleteUser(User user) throws AuthorizationAccessException {
                                            if (!baseConfigurableUserGroupProvider.isConfigurable(user)) {
                                                throw new IllegalArgumentException("The specified user does not support modification.");
                                            }
                                            return baseConfigurableUserGroupProvider.deleteUser(user);
                                        }

                                        public Group addGroup(Group group) throws AuthorizationAccessException {
                                            if (AuthorizerFactory.tenantExists((UserGroupProvider)baseConfigurableUserGroupProvider, group.getIdentifier(), group.getName())) {
                                                throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", group.getName()));
                                            }
                                            if (!AuthorizerFactory.allGroupUsersExist((UserGroupProvider)baseConfigurableUserGroupProvider, group)) {
                                                throw new IllegalStateException(String.format("Cannot create group '%s' with users that don't exist.", group.getName()));
                                            }
                                            return baseConfigurableUserGroupProvider.addGroup(group);
                                        }

                                        public boolean isConfigurable(Group group) {
                                            return baseConfigurableUserGroupProvider.isConfigurable(group);
                                        }

                                        public Group updateGroup(Group group) throws AuthorizationAccessException {
                                            if (AuthorizerFactory.tenantExists((UserGroupProvider)baseConfigurableUserGroupProvider, group.getIdentifier(), group.getName())) {
                                                throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", group.getName()));
                                            }
                                            if (!AuthorizerFactory.allGroupUsersExist((UserGroupProvider)baseConfigurableUserGroupProvider, group)) {
                                                throw new IllegalStateException(String.format("Cannot update group '%s' to add users that don't exist.", group.getName()));
                                            }
                                            if (!baseConfigurableUserGroupProvider.isConfigurable(group)) {
                                                throw new IllegalArgumentException("The specified group does not support modification.");
                                            }
                                            return baseConfigurableUserGroupProvider.updateGroup(group);
                                        }

                                        public Group deleteGroup(Group group) throws AuthorizationAccessException {
                                            if (!baseConfigurableUserGroupProvider.isConfigurable(group)) {
                                                throw new IllegalArgumentException("The specified group does not support modification.");
                                            }
                                            return baseConfigurableUserGroupProvider.deleteGroup(group);
                                        }

                                        public Set<User> getUsers() throws AuthorizationAccessException {
                                            return baseConfigurableUserGroupProvider.getUsers();
                                        }

                                        public User getUser(String identifier) throws AuthorizationAccessException {
                                            return baseConfigurableUserGroupProvider.getUser(identifier);
                                        }

                                        public User getUserByIdentity(String identity) throws AuthorizationAccessException {
                                            return baseConfigurableUserGroupProvider.getUserByIdentity(identity);
                                        }

                                        public Set<Group> getGroups() throws AuthorizationAccessException {
                                            return baseConfigurableUserGroupProvider.getGroups();
                                        }

                                        public Group getGroup(String identifier) throws AuthorizationAccessException {
                                            return baseConfigurableUserGroupProvider.getGroup(identifier);
                                        }

                                        public UserAndGroups getUserAndGroups(String identity) throws AuthorizationAccessException {
                                            return baseConfigurableUserGroupProvider.getUserAndGroups(identity);
                                        }

                                        public void initialize(UserGroupProviderInitializationContext initializationContext) throws AuthorizerCreationException {
                                            baseConfigurableUserGroupProvider.initialize(initializationContext);
                                        }

                                        public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
                                            baseConfigurableUserGroupProvider.onConfigured(configurationContext);
                                        }

                                        public void preDestruction() throws AuthorizerDestructionException {
                                            baseConfigurableUserGroupProvider.preDestruction();
                                        }
                                    };
                                }
                                return baseUserGroupProvider;
                            }

                            public void initialize(AccessPolicyProviderInitializationContext initializationContext) throws AuthorizerCreationException {
                                baseConfigurableAccessPolicyProvider.initialize(initializationContext);
                            }

                            public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
                                baseConfigurableAccessPolicyProvider.onConfigured(configurationContext);
                            }

                            public void preDestruction() throws AuthorizerDestructionException {
                                baseConfigurableAccessPolicyProvider.preDestruction();
                            }
                        };
                    }
                    return baseAccessPolicyProvider;
                }

                public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
                    AuthorizationResult result = baseAuthorizer.authorize(request);
                    AuthorizerFactory.audit(baseAuthorizer, request, result);
                    return result;
                }

                public void initialize(AuthorizerInitializationContext initializationContext) throws AuthorizerCreationException {
                    baseManagedAuthorizer.initialize(initializationContext);
                }

                public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
                    baseManagedAuthorizer.onConfigured(configurationContext);
                    AccessPolicyProvider accessPolicyProvider = baseManagedAuthorizer.getAccessPolicyProvider();
                    UserGroupProvider userGroupProvider = accessPolicyProvider.getUserGroupProvider();
                    for (AccessPolicy accessPolicy : accessPolicyProvider.getAccessPolicies()) {
                        if (!AuthorizerFactory.policyExists(accessPolicyProvider, accessPolicy)) continue;
                        throw new AuthorizerCreationException(String.format("Found multiple policies for '%s' with '%s'.", accessPolicy.getResource(), accessPolicy.getAction()));
                    }
                    for (User user : userGroupProvider.getUsers()) {
                        if (!AuthorizerFactory.tenantExists(userGroupProvider, user.getIdentifier(), user.getIdentity())) continue;
                        throw new AuthorizerCreationException(String.format("Found multiple users/user groups with identity '%s'.", user.getIdentity()));
                    }
                    for (Group group : userGroupProvider.getGroups()) {
                        if (!AuthorizerFactory.tenantExists(userGroupProvider, group.getIdentifier(), group.getName())) continue;
                        throw new AuthorizerCreationException(String.format("Found multiple users/user groups with name '%s'.", group.getName()));
                    }
                }

                public void preDestruction() throws AuthorizerDestructionException {
                    baseManagedAuthorizer.preDestruction();
                }
            };
        } else {
            authorizer = new Authorizer(){

                public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
                    AuthorizationResult result = baseAuthorizer.authorize(request);
                    AuthorizerFactory.audit(baseAuthorizer, request, result);
                    return result;
                }

                public void initialize(AuthorizerInitializationContext initializationContext) throws AuthorizerCreationException {
                    baseAuthorizer.initialize(initializationContext);
                }

                public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
                    baseAuthorizer.onConfigured(configurationContext);
                }

                public void preDestruction() throws AuthorizerDestructionException {
                    baseAuthorizer.preDestruction();
                }
            };
        }
        if (baseAuthorizer instanceof AuthorizationAuditor) {
            AuthorizationAuditorInvocationHandler invocationHandler = new AuthorizationAuditorInvocationHandler((Authorizer)authorizer, (AuthorizationAuditor)baseAuthorizer);
            List interfaceList = ClassUtils.getAllInterfaces(authorizer.getClass());
            interfaceList.add(AuthorizationAuditor.class);
            Class[] interfaces = interfaceList.toArray(new Class[interfaceList.size()]);
            authorizer = (Authorizer)Proxy.newProxyInstance(authorizer.getClass().getClassLoader(), interfaces, (InvocationHandler)invocationHandler);
        }
        return authorizer;
    }

    public static Authorizer withNarLoader(Authorizer baseAuthorizer, ClassLoader classLoader) {
        AuthorizerInvocationHandler invocationHandler = new AuthorizerInvocationHandler(baseAuthorizer, classLoader);
        List interfaceList = ClassUtils.getAllInterfaces(baseAuthorizer.getClass());
        Class[] interfaces = interfaceList.toArray(new Class[interfaceList.size()]);
        return (Authorizer)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)invocationHandler);
    }

    private AuthorizerFactory() {
    }
}

