/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessPolicyProviderFactory;
import org.apache.nifi.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.authorization.AccessPolicyProviderLookup;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.AuthorizerFactory;
import org.apache.nifi.authorization.AuthorizerInitializationContext;
import org.apache.nifi.authorization.AuthorizerLookup;
import org.apache.nifi.authorization.StandardAuthorizerConfigurationContext;
import org.apache.nifi.authorization.StandardAuthorizerInitializationContext;
import org.apache.nifi.authorization.UserGroupProviderFactory;
import org.apache.nifi.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.authorization.UserGroupProviderLookup;
import org.apache.nifi.authorization.annotation.AuthorizerContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.authorization.generated.AccessPolicyProvider;
import org.apache.nifi.authorization.generated.Authorizers;
import org.apache.nifi.authorization.generated.Property;
import org.apache.nifi.authorization.generated.UserGroupProvider;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.properties.AESSensitivePropertyProviderFactory;
import org.apache.nifi.properties.NiFiPropertiesLoader;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.security.xml.XmlUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.xml.sax.SAXException;

public class AuthorizerFactoryBean
implements FactoryBean,
DisposableBean,
UserGroupProviderLookup,
AccessPolicyProviderLookup,
AuthorizerLookup {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizerFactoryBean.class);
    private static final String AUTHORIZERS_XSD = "/authorizers.xsd";
    private static final String JAXB_GENERATED_PATH = "org.apache.nifi.authorization.generated";
    private static final JAXBContext JAXB_CONTEXT = AuthorizerFactoryBean.initializeJaxbContext();
    private static SensitivePropertyProviderFactory SENSITIVE_PROPERTY_PROVIDER_FACTORY;
    private static SensitivePropertyProvider SENSITIVE_PROPERTY_PROVIDER;
    private Authorizer authorizer;
    private NiFiProperties properties;
    private final Map<String, org.apache.nifi.authorization.UserGroupProvider> userGroupProviders = new HashMap<String, org.apache.nifi.authorization.UserGroupProvider>();
    private final Map<String, org.apache.nifi.authorization.AccessPolicyProvider> accessPolicyProviders = new HashMap<String, org.apache.nifi.authorization.AccessPolicyProvider>();
    private final Map<String, Authorizer> authorizers = new HashMap<String, Authorizer>();

    private static JAXBContext initializeJaxbContext() {
        try {
            return JAXBContext.newInstance((String)JAXB_GENERATED_PATH, (ClassLoader)AuthorizerFactoryBean.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext.");
        }
    }

    public org.apache.nifi.authorization.UserGroupProvider getUserGroupProvider(String identifier) {
        return this.userGroupProviders.get(identifier);
    }

    public org.apache.nifi.authorization.AccessPolicyProvider getAccessPolicyProvider(String identifier) {
        return this.accessPolicyProviders.get(identifier);
    }

    public Authorizer getAuthorizer(String identifier) {
        return this.authorizers.get(identifier);
    }

    public Object getObject() throws Exception {
        if (this.authorizer == null) {
            if (this.properties.getSslPort() == null) {
                this.authorizer = this.createDefaultAuthorizer();
            } else {
                org.apache.nifi.authorization.UserGroupProvider instance;
                String authorizerIdentifier = this.properties.getProperty("nifi.security.user.authorizer");
                if (StringUtils.isBlank((CharSequence)authorizerIdentifier)) {
                    throw new Exception("When running securely, the authorizer identifier must be specified in the nifi properties file.");
                }
                Authorizers authorizerConfiguration = this.loadAuthorizersConfiguration();
                for (UserGroupProvider userGroupProvider : authorizerConfiguration.getUserGroupProvider()) {
                    if (this.userGroupProviders.containsKey(userGroupProvider.getIdentifier())) {
                        throw new Exception("Duplicate User Group Provider identifier in Authorizers configuration: " + userGroupProvider.getIdentifier());
                    }
                    this.userGroupProviders.put(userGroupProvider.getIdentifier(), this.createUserGroupProvider(userGroupProvider.getIdentifier(), userGroupProvider.getClazz()));
                }
                for (UserGroupProvider userGroupProvider : authorizerConfiguration.getUserGroupProvider()) {
                    instance = this.userGroupProviders.get(userGroupProvider.getIdentifier());
                    instance.onConfigured(this.loadAuthorizerConfiguration(userGroupProvider.getIdentifier(), userGroupProvider.getProperty()));
                }
                for (AccessPolicyProvider accessPolicyProvider : authorizerConfiguration.getAccessPolicyProvider()) {
                    if (this.accessPolicyProviders.containsKey(accessPolicyProvider.getIdentifier())) {
                        throw new Exception("Duplicate Access Policy Provider identifier in Authorizers configuration: " + accessPolicyProvider.getIdentifier());
                    }
                    this.accessPolicyProviders.put(accessPolicyProvider.getIdentifier(), this.createAccessPolicyProvider(accessPolicyProvider.getIdentifier(), accessPolicyProvider.getClazz()));
                }
                for (AccessPolicyProvider accessPolicyProvider : authorizerConfiguration.getAccessPolicyProvider()) {
                    instance = this.accessPolicyProviders.get(accessPolicyProvider.getIdentifier());
                    instance.onConfigured(this.loadAuthorizerConfiguration(accessPolicyProvider.getIdentifier(), accessPolicyProvider.getProperty()));
                }
                for (org.apache.nifi.authorization.generated.Authorizer authorizer : authorizerConfiguration.getAuthorizer()) {
                    if (this.authorizers.containsKey(authorizer.getIdentifier())) {
                        throw new Exception("Duplicate Authorizer identifier in Authorizers configuration: " + authorizer.getIdentifier());
                    }
                    this.authorizers.put(authorizer.getIdentifier(), this.createAuthorizer(authorizer.getIdentifier(), authorizer.getClazz(), authorizer.getClasspath()));
                }
                for (org.apache.nifi.authorization.generated.Authorizer authorizer : authorizerConfiguration.getAuthorizer()) {
                    instance = this.authorizers.get(authorizer.getIdentifier());
                    instance.onConfigured(this.loadAuthorizerConfiguration(authorizer.getIdentifier(), authorizer.getProperty()));
                }
                this.authorizer = this.getAuthorizer(authorizerIdentifier);
                if (this.authorizer == null) {
                    throw new Exception(String.format("The specified authorizer '%s' could not be found.", authorizerIdentifier));
                }
                this.authorizer = AuthorizerFactory.installIntegrityChecks(this.authorizer);
            }
        }
        return this.authorizer;
    }

    private Authorizers loadAuthorizersConfiguration() throws Exception {
        File authorizersConfigurationFile = this.properties.getAuthorizerConfigurationFile();
        if (authorizersConfigurationFile.exists()) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(Authorizers.class.getResource(AUTHORIZERS_XSD));
                XMLStreamReader xsr = XmlUtils.createSafeReader((StreamSource)new StreamSource(authorizersConfigurationFile));
                Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
                unmarshaller.setSchema(schema);
                JAXBElement element = unmarshaller.unmarshal(xsr, Authorizers.class);
                return (Authorizers)element.getValue();
            }
            catch (JAXBException | XMLStreamException | SAXException e) {
                throw new Exception("Unable to load the authorizer configuration file at: " + authorizersConfigurationFile.getAbsolutePath(), e);
            }
        }
        throw new Exception("Unable to find the authorizer configuration file at " + authorizersConfigurationFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.nifi.authorization.UserGroupProvider createUserGroupProvider(String identifier, String userGroupProviderClassName) throws Exception {
        org.apache.nifi.authorization.UserGroupProvider instance;
        List userGroupProviderBundles = ExtensionManager.getBundles((String)userGroupProviderClassName);
        if (userGroupProviderBundles.size() == 0) {
            throw new Exception(String.format("The specified user group provider class '%s' is not known to this nifi.", userGroupProviderClassName));
        }
        if (userGroupProviderBundles.size() > 1) {
            throw new Exception(String.format("Multiple bundles found for the specified user group provider class '%s', only one is allowed.", userGroupProviderClassName));
        }
        Bundle userGroupProviderBundle = (Bundle)userGroupProviderBundles.get(0);
        ClassLoader userGroupProviderClassLoader = userGroupProviderBundle.getClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(userGroupProviderClassLoader);
            Class<?> rawUserGroupProviderClass = Class.forName(userGroupProviderClassName, true, userGroupProviderClassLoader);
            Class<org.apache.nifi.authorization.UserGroupProvider> userGroupProviderClass = rawUserGroupProviderClass.asSubclass(org.apache.nifi.authorization.UserGroupProvider.class);
            Constructor<org.apache.nifi.authorization.UserGroupProvider> constructor = userGroupProviderClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, userGroupProviderClass);
            this.performFieldInjection(instance, userGroupProviderClass);
            instance.initialize((UserGroupProviderInitializationContext)new StandardAuthorizerInitializationContext(identifier, (UserGroupProviderLookup)this, (AccessPolicyProviderLookup)this, (AuthorizerLookup)this));
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return UserGroupProviderFactory.withNarLoader(instance, userGroupProviderClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.nifi.authorization.AccessPolicyProvider createAccessPolicyProvider(String identifier, String accessPolicyProviderClassName) throws Exception {
        org.apache.nifi.authorization.AccessPolicyProvider instance;
        List accessPolicyProviderBundles = ExtensionManager.getBundles((String)accessPolicyProviderClassName);
        if (accessPolicyProviderBundles.size() == 0) {
            throw new Exception(String.format("The specified access policy provider class '%s' is not known to this nifi.", accessPolicyProviderClassName));
        }
        if (accessPolicyProviderBundles.size() > 1) {
            throw new Exception(String.format("Multiple bundles found for the specified access policy provider class '%s', only one is allowed.", accessPolicyProviderClassName));
        }
        Bundle accessPolicyProviderBundle = (Bundle)accessPolicyProviderBundles.get(0);
        ClassLoader accessPolicyProviderClassLoader = accessPolicyProviderBundle.getClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(accessPolicyProviderClassLoader);
            Class<?> rawAccessPolicyProviderClass = Class.forName(accessPolicyProviderClassName, true, accessPolicyProviderClassLoader);
            Class<org.apache.nifi.authorization.AccessPolicyProvider> accessPolicyClass = rawAccessPolicyProviderClass.asSubclass(org.apache.nifi.authorization.AccessPolicyProvider.class);
            Constructor<org.apache.nifi.authorization.AccessPolicyProvider> constructor = accessPolicyClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, accessPolicyClass);
            this.performFieldInjection(instance, accessPolicyClass);
            instance.initialize((AccessPolicyProviderInitializationContext)new StandardAuthorizerInitializationContext(identifier, (UserGroupProviderLookup)this, (AccessPolicyProviderLookup)this, (AuthorizerLookup)this));
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return AccessPolicyProviderFactory.withNarLoader(instance, accessPolicyProviderClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Authorizer createAuthorizer(String identifier, String authorizerClassName, String classpathResources) throws Exception {
        Authorizer instance;
        List authorizerBundles = ExtensionManager.getBundles((String)authorizerClassName);
        if (authorizerBundles.size() == 0) {
            throw new Exception(String.format("The specified authorizer class '%s' is not known to this nifi.", authorizerClassName));
        }
        if (authorizerBundles.size() > 1) {
            throw new Exception(String.format("Multiple bundles found for the specified authorizer class '%s', only one is allowed.", authorizerClassName));
        }
        Bundle authorizerBundle = (Bundle)authorizerBundles.get(0);
        ClassLoader authorizerClassLoader = authorizerBundle.getClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(authorizerClassLoader);
            Class<?> rawAuthorizerClass = Class.forName(authorizerClassName, true, authorizerClassLoader);
            Class<Authorizer> authorizerClass = rawAuthorizerClass.asSubclass(Authorizer.class);
            Constructor<Authorizer> constructor = authorizerClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, authorizerClass);
            this.performFieldInjection(instance, authorizerClass);
            instance.initialize((AuthorizerInitializationContext)new StandardAuthorizerInitializationContext(identifier, (UserGroupProviderLookup)this, (AccessPolicyProviderLookup)this, (AuthorizerLookup)this));
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)classpathResources)) {
            URL[] urls = ClassLoaderUtils.getURLsForClasspath((String)classpathResources, null, (boolean)true);
            authorizerClassLoader = new URLClassLoader(urls, authorizerClassLoader);
        }
        return AuthorizerFactory.withNarLoader(instance, authorizerClassLoader);
    }

    private AuthorizerConfigurationContext loadAuthorizerConfiguration(String identifier, List<Property> properties) {
        HashMap<String, String> authorizerProperties = new HashMap<String, String>();
        for (Property property : properties) {
            if (!StringUtils.isBlank((CharSequence)property.getEncryption())) {
                String decryptedValue = this.decryptValue(property.getValue(), property.getEncryption());
                authorizerProperties.put(property.getName(), decryptedValue);
                continue;
            }
            authorizerProperties.put(property.getName(), property.getValue());
        }
        return new StandardAuthorizerConfigurationContext(identifier, authorizerProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performMethodInjection(Object instance, Class authorizerClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : authorizerClass.getMethods()) {
            if (!method.isAnnotationPresent(AuthorizerContext.class)) continue;
            boolean isAccessible = method.isAccessible();
            method.setAccessible(true);
            try {
                Class<?> argumentType;
                Class<?>[] argumentTypes = method.getParameterTypes();
                if (argumentTypes.length != 1 || !NiFiProperties.class.isAssignableFrom(argumentType = argumentTypes[0])) continue;
                method.invoke(instance, this.properties);
            }
            finally {
                method.setAccessible(isAccessible);
            }
        }
        Class parentClass = authorizerClass.getSuperclass();
        if (parentClass != null && Authorizer.class.isAssignableFrom(parentClass)) {
            this.performMethodInjection(instance, parentClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performFieldInjection(Object instance, Class authorizerClass) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : authorizerClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(AuthorizerContext.class)) continue;
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Class<?> fieldType = field.getType();
                if (field.get(instance) != null || !NiFiProperties.class.isAssignableFrom(fieldType)) continue;
                field.set(instance, this.properties);
            }
            finally {
                field.setAccessible(isAccessible);
            }
        }
        Class parentClass = authorizerClass.getSuperclass();
        if (parentClass != null && Authorizer.class.isAssignableFrom(parentClass)) {
            this.performFieldInjection(instance, parentClass);
        }
    }

    private Authorizer createDefaultAuthorizer() {
        return new Authorizer(){

            public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
                return AuthorizationResult.approved();
            }

            public void initialize(AuthorizerInitializationContext initializationContext) throws AuthorizerCreationException {
            }

            public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
            }

            public void preDestruction() throws AuthorizerDestructionException {
            }
        };
    }

    private String decryptValue(String cipherText, String encryptionScheme) throws SensitivePropertyProtectionException {
        AuthorizerFactoryBean.initializeSensitivePropertyProvider(encryptionScheme);
        return SENSITIVE_PROPERTY_PROVIDER.unprotect(cipherText);
    }

    private static void initializeSensitivePropertyProvider(String encryptionScheme) throws SensitivePropertyProtectionException {
        if (SENSITIVE_PROPERTY_PROVIDER == null || !SENSITIVE_PROPERTY_PROVIDER.getIdentifierKey().equalsIgnoreCase(encryptionScheme)) {
            try {
                String keyHex = AuthorizerFactoryBean.getMasterKey();
                SENSITIVE_PROPERTY_PROVIDER_FACTORY = new AESSensitivePropertyProviderFactory(keyHex);
                SENSITIVE_PROPERTY_PROVIDER = SENSITIVE_PROPERTY_PROVIDER_FACTORY.getProvider();
            }
            catch (IOException e) {
                logger.error("Error extracting master key from bootstrap.conf for login identity provider decryption", (Throwable)e);
                throw new SensitivePropertyProtectionException("Could not read master key from bootstrap.conf");
            }
        }
    }

    private static String getMasterKey() throws IOException {
        return NiFiPropertiesLoader.extractKeyFromBootstrapFile();
    }

    public Class getObjectType() {
        return Authorizer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        ArrayList errors = new ArrayList();
        if (this.authorizers != null) {
            this.authorizers.forEach((identifier, object) -> {
                try {
                    object.preDestruction();
                }
                catch (Exception e) {
                    errors.add(e);
                    logger.error("Error pre-destructing {}: {}", identifier, (Object)e);
                }
            });
        }
        if (this.accessPolicyProviders != null) {
            this.accessPolicyProviders.forEach((identifier, object) -> {
                try {
                    object.preDestruction();
                }
                catch (Exception e) {
                    errors.add(e);
                    logger.error("Error pre-destructing {}: {}", identifier, (Object)e);
                }
            });
        }
        if (this.userGroupProviders != null) {
            this.userGroupProviders.forEach((identifier, object) -> {
                try {
                    object.preDestruction();
                }
                catch (Exception e) {
                    errors.add(e);
                    logger.error("Error pre-destructing {}: {}", identifier, (Object)e);
                }
            });
        }
        if (!errors.isEmpty()) {
            List errorMessages = errors.stream().map(Throwable::toString).collect(Collectors.toList());
            throw new AuthorizerDestructionException("One or more providers encountered a pre-destruction error: " + StringUtils.join(errorMessages, (String)"; "), (Throwable)errors.get(0));
        }
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

