/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.util.DateTimeAdapter;

@XmlType(name="remoteProcessGroup")
public class RemoteProcessGroupDTO
extends ComponentDTO {
    private String targetUri;
    private String targetUris;
    private Boolean targetSecure;
    private String name;
    private String comments;
    private String communicationsTimeout;
    private String yieldDuration;
    private String transportProtocol;
    private String localNetworkInterface;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private Collection<String> authorizationIssues;
    private Collection<String> validationErrors;
    private Boolean transmitting;
    private Integer inputPortCount;
    private Integer outputPortCount;
    private Integer activeRemoteInputPortCount;
    private Integer inactiveRemoteInputPortCount;
    private Integer activeRemoteOutputPortCount;
    private Integer inactiveRemoteOutputPortCount;
    private Date flowRefreshed;
    private RemoteProcessGroupContentsDTO contents;

    public RemoteProcessGroupDTO() {
    }

    public RemoteProcessGroupDTO(RemoteProcessGroupDTO toCopy) {
        this.setId(toCopy.getId());
        this.setPosition(toCopy.getPosition());
        this.targetUri = toCopy.getTargetUri();
        this.name = toCopy.getName();
    }

    public void setTargetUri(String targetUri) {
        this.targetUri = targetUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiModelProperty(value="The target URI of the remote process group. If target uri is not set, but uris are set, then returns the first url in the urls. If neither target uri nor uris are set, then returns null.")
    public String getTargetUri() {
        if (this.targetUri == null || this.targetUri.length() == 0) {
            RemoteProcessGroupDTO remoteProcessGroupDTO = this;
            synchronized (remoteProcessGroupDTO) {
                if ((this.targetUri == null || this.targetUri.length() == 0) && this.targetUris != null && this.targetUris.length() > 0) {
                    this.targetUri = this.targetUris.indexOf(44) > -1 ? this.targetUris.substring(0, this.targetUris.indexOf(44)) : this.targetUris;
                }
            }
        }
        return this.targetUri;
    }

    public void setTargetUris(String targetUris) {
        this.targetUris = targetUris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiModelProperty(value="The target URI of the remote process group. If target uris is not set but target uri is set, then returns a collection containing the single target uri. If neither target uris nor uris are set, then returns null.")
    public String getTargetUris() {
        if (this.targetUris == null || this.targetUris.length() == 0) {
            RemoteProcessGroupDTO remoteProcessGroupDTO = this;
            synchronized (remoteProcessGroupDTO) {
                if (this.targetUris == null || this.targetUris.length() == 0) {
                    this.targetUris = this.targetUri;
                }
            }
        }
        return this.targetUris;
    }

    @ApiModelProperty(value="The name of the remote process group.")
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The comments for the remote process group.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @ApiModelProperty(value="Any remote authorization issues for the remote process group.")
    public Collection<String> getAuthorizationIssues() {
        return this.authorizationIssues;
    }

    public void setAuthorizationIssues(Collection<String> authorizationIssues) {
        this.authorizationIssues = authorizationIssues;
    }

    @ApiModelProperty(value="Whether the remote process group is actively transmitting.")
    public Boolean isTransmitting() {
        return this.transmitting;
    }

    public void setTransmitting(Boolean transmitting) {
        this.transmitting = transmitting;
    }

    @ApiModelProperty(value="Whether the target is running securely.")
    public Boolean isTargetSecure() {
        return this.targetSecure;
    }

    public void setTargetSecure(Boolean targetSecure) {
        this.targetSecure = targetSecure;
    }

    @ApiModelProperty(value="The time period used for the timeout when communicating with the target.")
    public String getCommunicationsTimeout() {
        return this.communicationsTimeout;
    }

    public void setCommunicationsTimeout(String communicationsTimeout) {
        this.communicationsTimeout = communicationsTimeout;
    }

    @ApiModelProperty(value="When yielding, this amount of time must elapse before the remote process group is scheduled again.")
    public String getYieldDuration() {
        return this.yieldDuration;
    }

    public void setYieldDuration(String yieldDuration) {
        this.yieldDuration = yieldDuration;
    }

    @ApiModelProperty(value="The number of active remote input ports.")
    public Integer getActiveRemoteInputPortCount() {
        return this.activeRemoteInputPortCount;
    }

    public void setActiveRemoteInputPortCount(Integer activeRemoteInputPortCount) {
        this.activeRemoteInputPortCount = activeRemoteInputPortCount;
    }

    @ApiModelProperty(value="The number of inactive remote input ports.")
    public Integer getInactiveRemoteInputPortCount() {
        return this.inactiveRemoteInputPortCount;
    }

    public void setInactiveRemoteInputPortCount(Integer inactiveRemoteInputPortCount) {
        this.inactiveRemoteInputPortCount = inactiveRemoteInputPortCount;
    }

    @ApiModelProperty(value="The number of active remote output ports.")
    public Integer getActiveRemoteOutputPortCount() {
        return this.activeRemoteOutputPortCount;
    }

    public void setActiveRemoteOutputPortCount(Integer activeRemoteOutputPortCount) {
        this.activeRemoteOutputPortCount = activeRemoteOutputPortCount;
    }

    @ApiModelProperty(value="The number of inactive remote output ports.")
    public Integer getInactiveRemoteOutputPortCount() {
        return this.inactiveRemoteOutputPortCount;
    }

    public void setInactiveRemoteOutputPortCount(Integer inactiveRemoteOutputPortCount) {
        this.inactiveRemoteOutputPortCount = inactiveRemoteOutputPortCount;
    }

    @ApiModelProperty(value="The number of remote input ports currently available on the target.")
    public Integer getInputPortCount() {
        return this.inputPortCount;
    }

    public void setInputPortCount(Integer inputPortCount) {
        this.inputPortCount = inputPortCount;
    }

    @ApiModelProperty(value="The number of remote output ports currently available on the target.")
    public Integer getOutputPortCount() {
        return this.outputPortCount;
    }

    public void setOutputPortCount(Integer outputPortCount) {
        this.outputPortCount = outputPortCount;
    }

    @ApiModelProperty(value="The contents of the remote process group. Will contain available input/output ports.")
    public RemoteProcessGroupContentsDTO getContents() {
        return this.contents;
    }

    public void setContents(RemoteProcessGroupContentsDTO contents) {
        this.contents = contents;
    }

    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @ApiModelProperty(value="The timestamp when this remote process group was last refreshed.", dataType="string")
    public Date getFlowRefreshed() {
        return this.flowRefreshed;
    }

    public void setFlowRefreshed(Date flowRefreshed) {
        this.flowRefreshed = flowRefreshed;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    @ApiModelProperty(value="The local network interface to send/receive data. If not specified, any local address is used. If clustered, all nodes must have an interface with this identifier.")
    public String getLocalNetworkInterface() {
        return this.localNetworkInterface;
    }

    public void setLocalNetworkInterface(String localNetworkInterface) {
        this.localNetworkInterface = localNetworkInterface;
    }

    @ApiModelProperty(value="The validation errors for the remote process group. These validation errors represent the problems with the remote process group that must be resolved before it can transmit.")
    public Collection<String> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(Collection<String> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }
}

