/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.status;

import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.nifi.web.api.dto.status.NodeProcessorStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.util.TimeAdapter;

@XmlType(name="processorStatus")
public class ProcessorStatusDTO
implements Cloneable {
    private String groupId;
    private String id;
    private String name;
    private String type;
    private String runStatus;
    private Date statsLastRefreshed;
    private ProcessorStatusSnapshotDTO aggregateSnapshot;
    private List<NodeProcessorStatusSnapshotDTO> nodeSnapshots;

    @ApiModelProperty(value="The unique ID of the process group that the Processor belongs to")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ApiModelProperty(value="The unique ID of the Processor")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The name of the Processor")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The type of the Processor")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ApiModelProperty(value="The run status of the Processor")
    public String getRunStatus() {
        return this.runStatus;
    }

    public void setRunStatus(String runStatus) {
        this.runStatus = runStatus;
    }

    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    @ApiModelProperty(value="The timestamp of when the stats were last refreshed", dataType="string")
    public Date getStatsLastRefreshed() {
        return this.statsLastRefreshed;
    }

    public void setStatsLastRefreshed(Date statsLastRefreshed) {
        this.statsLastRefreshed = statsLastRefreshed;
    }

    @ApiModelProperty(value="A status snapshot that represents the aggregate stats of all nodes in the cluster. If the NiFi instance is a standalone instance, rather than a cluster, this represents the stats of the single instance.")
    public ProcessorStatusSnapshotDTO getAggregateSnapshot() {
        return this.aggregateSnapshot;
    }

    public void setAggregateSnapshot(ProcessorStatusSnapshotDTO aggregateSnapshot) {
        this.aggregateSnapshot = aggregateSnapshot;
    }

    @ApiModelProperty(value="A status snapshot for each node in the cluster. If the NiFi instance is a standalone instance, rather than a cluster, this may be null.")
    public List<NodeProcessorStatusSnapshotDTO> getNodeSnapshots() {
        return this.nodeSnapshots;
    }

    public void setNodeSnapshots(List<NodeProcessorStatusSnapshotDTO> nodeSnapshots) {
        this.nodeSnapshots = nodeSnapshots;
    }

    public ProcessorStatusDTO clone() {
        ProcessorStatusDTO other = new ProcessorStatusDTO();
        other.setGroupId(this.getGroupId());
        other.setId(this.getId());
        other.setName(this.getName());
        other.setRunStatus(this.getRunStatus());
        other.setType(this.getType());
        other.setStatsLastRefreshed(this.getStatsLastRefreshed());
        other.setAggregateSnapshot(this.getAggregateSnapshot().clone());
        List<NodeProcessorStatusSnapshotDTO> nodeStatuses = this.getNodeSnapshots();
        ArrayList<NodeProcessorStatusSnapshotDTO> nodeStatusClones = new ArrayList<NodeProcessorStatusSnapshotDTO>(nodeStatuses.size());
        for (NodeProcessorStatusSnapshotDTO status : nodeStatuses) {
            nodeStatusClones.add(status.clone());
        }
        other.setNodeSnapshots(nodeStatusClones);
        return other;
    }
}

