/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.antlr.runtime.tree.Tree;
import org.apache.nifi.attribute.expression.language.CompiledExpression;
import org.apache.nifi.attribute.expression.language.EmptyPreparedQuery;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.Expression;
import org.apache.nifi.attribute.expression.language.InvalidPreparedQuery;
import org.apache.nifi.attribute.expression.language.ParameterExpression;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.attribute.expression.language.StandardPreparedQuery;
import org.apache.nifi.attribute.expression.language.StringLiteralExpression;
import org.apache.nifi.attribute.expression.language.compile.ExpressionCompiler;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.EvaluatorState;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AttributeEvaluator;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.parameter.ExpressionLanguageAwareParameterParser;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterParser;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterToken;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.processor.exception.ProcessException;

public class Query {
    private final String query;
    private final Tree tree;
    private final Evaluator<?> evaluator;
    private final AtomicBoolean evaluated = new AtomicBoolean(false);
    private final EvaluatorState context = new EvaluatorState();

    private Query(String query, Tree tree, Evaluator<?> evaluator) {
        this.query = query;
        this.tree = tree;
        this.evaluator = evaluator;
    }

    public static boolean isValidExpression(String value) {
        try {
            Query.validateExpression(value, false);
            return true;
        }
        catch (AttributeExpressionLanguageParsingException | ProcessException e) {
            return false;
        }
    }

    public static AttributeExpression.ResultType getResultType(String value) throws AttributeExpressionLanguageParsingException {
        return Query.compile(value).getResultType();
    }

    public static List<AttributeExpression.ResultType> extractResultTypes(String value) throws AttributeExpressionLanguageParsingException {
        ArrayList<AttributeExpression.ResultType> types = new ArrayList<AttributeExpression.ResultType>();
        for (Range range : Query.extractExpressionRanges(value)) {
            String text = value.substring(range.getStart(), range.getEnd() + 1);
            types.add(Query.getResultType(text));
        }
        return types;
    }

    public static List<String> extractExpressions(String value) throws AttributeExpressionLanguageParsingException {
        ArrayList<String> expressions = new ArrayList<String>();
        for (Range range : Query.extractExpressionRanges(value)) {
            expressions.add(value.substring(range.getStart(), range.getEnd() + 1));
        }
        return expressions;
    }

    public static List<Range> extractExpressionRanges(String value) throws AttributeExpressionLanguageParsingException {
        return Query.extractExpressionRanges(value, false);
    }

    public static List<Range> extractEscapedRanges(String value) throws AttributeExpressionLanguageParsingException {
        return Query.extractExpressionRanges(value, true);
    }

    private static List<Range> extractExpressionRanges(String value, boolean extractEscapeSequences) throws AttributeExpressionLanguageParsingException {
        ArrayList<Range> ranges = new ArrayList<Range>();
        int lastChar = 0;
        int embeddedCount = 0;
        int expressionStart = -1;
        int dollarCount = 0;
        int backslashCount = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!(expressionStart <= -1 || c != '\'' && c != '\"' || lastChar == 92 && backslashCount % 2 != 0)) {
                int endQuoteIndex = Query.findEndQuoteChar(value, i);
                if (endQuoteIndex < 0) break;
                i = endQuoteIndex;
                continue;
            }
            if (c == '{') {
                boolean evenDollarCount;
                boolean bl = evenDollarCount = dollarCount % 2 == 0;
                if (evenDollarCount == extractEscapeSequences && lastChar == 36 && embeddedCount == 0) {
                    expressionStart = i - (extractEscapeSequences ? dollarCount : 1);
                }
                if (expressionStart > -1) {
                    ++embeddedCount;
                }
            } else if (c == '}') {
                if (embeddedCount <= 0) continue;
                if (--embeddedCount == 0) {
                    if (expressionStart > -1) {
                        Range range = new Range(expressionStart, i);
                        ranges.add(range);
                    }
                    expressionStart = -1;
                }
            } else if (c == '$') {
                ++dollarCount;
            } else if (c == '\\') {
                ++backslashCount;
            } else {
                dollarCount = 0;
            }
            lastChar = c;
        }
        return ranges;
    }

    public static void validateExpression(String value, boolean allowSurroundingCharacters) throws AttributeExpressionLanguageParsingException {
        if (!allowSurroundingCharacters) {
            List<Range> ranges = Query.extractExpressionRanges(value);
            if (ranges.size() > 1) {
                throw new AttributeExpressionLanguageParsingException("Found multiple Expressions but expected only 1");
            }
            if (ranges.isEmpty()) {
                throw new AttributeExpressionLanguageParsingException("No Expressions found");
            }
            Range range = ranges.get(0);
            String expression = value.substring(range.getStart(), range.getEnd() + 1);
            Query.compile(expression);
            if (range.getStart() > 0 || range.getEnd() < value.length() - 1) {
                throw new AttributeExpressionLanguageParsingException("Found characters outside of Expression");
            }
        } else {
            for (Range range : Query.extractExpressionRanges(value)) {
                String expression = value.substring(range.getStart(), range.getEnd() + 1);
                Query.compile(expression);
            }
        }
    }

    static int findEndQuoteChar(String value, int quoteStart) {
        char quoteChar = value.charAt(quoteStart);
        int backslashCount = 0;
        char lastChar = '\u0000';
        for (int i = quoteStart + 1; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                ++backslashCount;
            } else if (c == quoteChar && (backslashCount % 2 == 0 || lastChar != '\\')) {
                return i;
            }
            lastChar = c;
        }
        return -1;
    }

    static String evaluateExpression(Tree tree, Evaluator<?> rootEvaluator, String queryText, EvaluationContext evaluationContext, AttributeValueDecorator decorator) throws ProcessException {
        Query query = new Query(queryText, tree, rootEvaluator);
        Object evaluated = query.evaluate(evaluationContext).getValue();
        if (evaluated == null) {
            return null;
        }
        String value = evaluated.toString();
        return decorator == null ? value : decorator.decorate(value);
    }

    static String evaluateExpressions(String rawValue, Map<String, String> expressionMap, AttributeValueDecorator decorator, Map<String, String> stateVariables, ParameterLookup parameterLookup) throws ProcessException {
        return Query.prepare(rawValue).evaluateExpressions(new StandardEvaluationContext(expressionMap, stateVariables, parameterLookup), decorator);
    }

    static String evaluateExpressions(String rawValue, Map<String, String> valueLookup, ParameterLookup parameterLookup) throws ProcessException {
        return Query.evaluateExpressions(rawValue, valueLookup, null, parameterLookup);
    }

    static String evaluateExpressions(String rawValue, Map<String, String> valueLookup, AttributeValueDecorator decorator, ParameterLookup parameterLookup) throws ProcessException {
        return Query.prepare(rawValue).evaluateExpressions(new StandardEvaluationContext(valueLookup, Collections.emptyMap(), parameterLookup), decorator);
    }

    public static String unescape(String value) {
        return value.replaceAll("\\$\\$(?=\\$*\\{.*?\\})", "\\$");
    }

    public static Query fromTree(Tree tree, String text) {
        ExpressionCompiler compiler = new ExpressionCompiler();
        return new Query(text, tree, compiler.buildEvaluator(tree));
    }

    private static String unescapeLeadingDollarSigns(String value) {
        int index = value.indexOf("{");
        if (index < 0) {
            return value.replace("$$", "$");
        }
        String prefix = value.substring(0, index);
        return prefix.replace("$$", "$") + value.substring(index);
    }

    private static String unescapeTrailingDollarSigns(String value, boolean escapeIfAllDollars) {
        char c;
        if (!value.endsWith("$")) {
            return value;
        }
        int dollars = 0;
        for (int i = value.length() - 1; i >= 0 && (c = value.charAt(i)) == '$'; --i) {
            ++dollars;
        }
        if (dollars == value.length() && !escapeIfAllDollars) {
            return value;
        }
        int charsToRemove = dollars / 2;
        int newLength = value.length() - charsToRemove;
        return value.substring(0, newLength);
    }

    public static PreparedQuery prepareWithParametersPreEvaluated(String query) throws AttributeExpressionLanguageParsingException {
        return Query.prepare(query, true);
    }

    public static PreparedQuery prepare(String query) throws AttributeExpressionLanguageParsingException {
        return Query.prepare(query, false);
    }

    private static PreparedQuery prepare(String rawQuery, boolean escapeParameterReferences) throws AttributeExpressionLanguageParsingException {
        if (rawQuery == null) {
            return new EmptyPreparedQuery(null);
        }
        ExpressionLanguageAwareParameterParser parameterParser = new ExpressionLanguageAwareParameterParser();
        String query = escapeParameterReferences ? parameterParser.parseTokens(rawQuery).escape() : rawQuery;
        List<Range> ranges = Query.extractExpressionRanges(query);
        if (ranges.isEmpty()) {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            List<Range> escapedRanges = Query.extractEscapedRanges(query);
            int lastIndex = 0;
            for (Range range : escapedRanges) {
                String treeText = Query.unescapeLeadingDollarSigns(query.substring(range.getStart(), range.getEnd() + 1));
                if (range.getStart() > lastIndex) {
                    String substring = Query.unescapeLeadingDollarSigns(query.substring(lastIndex, range.getStart()));
                    Query.addLiteralsAndParameters((ParameterParser)parameterParser, substring, expressions, true);
                }
                Query.addLiteralsAndParameters((ParameterParser)parameterParser, treeText, expressions, true);
                lastIndex = range.getEnd() + 1;
            }
            if (escapedRanges.isEmpty()) {
                Query.addLiteralsAndParameters((ParameterParser)parameterParser, query, expressions, true);
            } else {
                Range lastRange = escapedRanges.get(escapedRanges.size() - 1);
                if (lastRange.getEnd() + 1 < query.length()) {
                    String treeText = Query.unescapeLeadingDollarSigns(query.substring(lastRange.getEnd() + 1));
                    Query.addLiteralsAndParameters((ParameterParser)parameterParser, treeText, expressions, true);
                }
            }
            if (expressions.isEmpty()) {
                return new EmptyPreparedQuery(query);
            }
            return new StandardPreparedQuery(expressions);
        }
        ExpressionCompiler compiler = new ExpressionCompiler();
        try {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            int lastIndex = 0;
            for (Range range : ranges) {
                String treeText = Query.unescapeLeadingDollarSigns(query.substring(range.getStart(), range.getEnd() + 1));
                CompiledExpression compiledExpression = compiler.compile(treeText);
                if (range.getStart() > lastIndex) {
                    String substring = Query.unescapeLeadingDollarSigns(query.substring(lastIndex, range.getStart()));
                    if (compiledExpression.getRootEvaluator() instanceof AttributeEvaluator) {
                        substring = Query.unescapeTrailingDollarSigns(substring, false);
                    }
                    Query.addLiteralsAndParameters((ParameterParser)parameterParser, substring, expressions, false);
                }
                expressions.add(compiledExpression);
                lastIndex = range.getEnd() + 1;
            }
            Range lastRange = ranges.get(ranges.size() - 1);
            if (lastRange.getEnd() + 1 < query.length()) {
                String treeText = Query.unescapeLeadingDollarSigns(query.substring(lastRange.getEnd() + 1));
                Query.addLiteralsAndParameters((ParameterParser)parameterParser, treeText, expressions, false);
            }
            return new StandardPreparedQuery(expressions);
        }
        catch (AttributeExpressionLanguageParsingException e) {
            return new InvalidPreparedQuery(query, e.getMessage());
        }
    }

    private static void addLiteralsAndParameters(ParameterParser parser, String input, List<Expression> expressions, boolean allowSensitiveParameterReference) {
        ParameterTokenList references = parser.parseTokens(input);
        int index = 0;
        ParameterToken lastReference = null;
        for (ParameterToken token : references) {
            if (token.isEscapeSequence()) {
                expressions.add(new StringLiteralExpression(token.getValue(ParameterLookup.EMPTY)));
                index = token.getEndOffset() + 1;
                lastReference = token;
                continue;
            }
            int start = token.getStartOffset();
            if (start > index) {
                expressions.add(new StringLiteralExpression(input.substring(index, start)));
            }
            if (token.isParameterReference()) {
                ParameterReference parameterReference = (ParameterReference)token;
                expressions.add(new ParameterExpression(parameterReference.getParameterName(), allowSensitiveParameterReference));
            } else {
                expressions.add(new StringLiteralExpression(token.getValue(ParameterLookup.EMPTY)));
            }
            index = token.getEndOffset() + 1;
            lastReference = token;
        }
        if (lastReference == null) {
            expressions.add(new StringLiteralExpression(input));
        } else if (input.length() > lastReference.getEndOffset() + 1) {
            expressions.add(new StringLiteralExpression(input.substring(lastReference.getEndOffset() + 1)));
        }
    }

    public static Query compile(String query) throws AttributeExpressionLanguageParsingException {
        try {
            ExpressionCompiler compiler = new ExpressionCompiler();
            CompiledExpression compiledExpression = compiler.compile(query);
            return new Query(compiledExpression.getExpression(), compiledExpression.getTree(), compiledExpression.getRootEvaluator());
        }
        catch (AttributeExpressionLanguageParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AttributeExpressionLanguageParsingException(e);
        }
    }

    public AttributeExpression.ResultType getResultType() {
        return this.evaluator.getResultType();
    }

    QueryResult<?> evaluate(EvaluationContext evaluationContext) {
        if (this.evaluated.getAndSet(true)) {
            throw new IllegalStateException("A Query cannot be evaluated more than once");
        }
        return this.evaluator.evaluate(evaluationContext);
    }

    Tree getTree() {
        return this.tree;
    }

    public String toString() {
        return "Query [" + this.query + "]";
    }

    public static class Range {
        private final int start;
        private final int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String toString() {
            return this.start + " - " + this.end;
        }
    }
}

