/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.registry.VariableRegistry;

final class ValueLookup
implements Map<String, String> {
    final List<Map<String, String>> maps = new ArrayList<Map<String, String>>();
    final VariableRegistry registry;

    ValueLookup(VariableRegistry registry, FlowFile flowFile, Map<String, String> ... additionalMaps) {
        for (Map<String, String> map : additionalMaps) {
            if (map == null || map.isEmpty()) continue;
            this.maps.add(map);
        }
        if (flowFile != null) {
            this.maps.add(ValueLookup.extractFlowFileProperties(flowFile));
            this.maps.add(flowFile.getAttributes());
        }
        this.registry = registry == null ? VariableRegistry.EMPTY_REGISTRY : registry;
    }

    static final Map<String, String> extractFlowFileProperties(FlowFile flowFile) {
        HashMap<String, String> flowFileProps = new HashMap<String, String>();
        flowFileProps.put("flowFileId", String.valueOf(flowFile.getId()));
        flowFileProps.put("fileSize", String.valueOf(flowFile.getSize()));
        flowFileProps.put("entryDate", String.valueOf(flowFile.getEntryDate()));
        flowFileProps.put("lineageStartDate", String.valueOf(flowFile.getLineageStartDate()));
        flowFileProps.put("lastQueueDate", String.valueOf(flowFile.getLastQueueDate()));
        flowFileProps.put("queueDateIndex", String.valueOf(flowFile.getQueueDateIndex()));
        return flowFileProps;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        for (Map<String, String> map : this.maps) {
            if (map.isEmpty()) continue;
            return false;
        }
        return this.registry.getVariableMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        if (this.maps.stream().anyMatch(map -> map.containsKey(key))) {
            return true;
        }
        return this.registry.getVariableKey(key.toString()) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Collection<String> values = this.values();
        return values.contains(value.toString());
    }

    @Override
    public String get(Object key) {
        if (key == null) {
            return null;
        }
        for (Map<String, String> map : this.maps) {
            String val = map.get(key.toString());
            if (val == null) continue;
            return val;
        }
        return this.registry.getVariableValue(key.toString());
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        this.entrySet().stream().forEach((? super T entry) -> keySet.add((String)entry.getKey()));
        return keySet;
    }

    @Override
    public Collection<String> values() {
        HashSet<String> values = new HashSet<String>();
        this.entrySet().stream().forEach((? super T entry) -> values.add((String)entry.getValue()));
        return values;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashMap newMap = new HashMap();
        for (Map.Entry entry : this.registry.getVariableMap().entrySet()) {
            newMap.put(((VariableDescriptor)entry.getKey()).getName(), entry.getValue());
        }
        ArrayList<Map<String, String>> listOfMaps = new ArrayList<Map<String, String>>(this.maps);
        Collections.reverse(listOfMaps);
        for (Map map : listOfMaps) {
            for (Map.Entry entry : map.entrySet()) {
                newMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        return newMap.entrySet();
    }
}

