/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class HostnameEvaluator
extends StringEvaluator {
    private final StringQueryResult hostname;

    public HostnameEvaluator(boolean preferFQDN) throws UnknownHostException {
        String address;
        if (preferFQDN) {
            try {
                address = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                address = InetAddress.getLocalHost().getHostName();
            }
        } else {
            address = InetAddress.getLocalHost().getHostName();
        }
        this.hostname = new StringQueryResult(address);
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        return this.hostname;
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return null;
    }
}

