/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class InEvaluator
extends BooleanEvaluator {
    private final Evaluator<String> subject;
    private final List<Evaluator<String>> search;

    public InEvaluator(Evaluator<String> subject, List<Evaluator<String>> list) {
        this.subject = subject;
        this.search = list;
    }

    @Override
    public QueryResult<Boolean> evaluate(Map<String, String> attributes) {
        Evaluator<String> evaluator;
        String searchString;
        String subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new BooleanQueryResult(false);
        }
        boolean isInList = false;
        Iterator<Evaluator<String>> iterator = this.search.iterator();
        while (iterator.hasNext() && !(isInList = (searchString = (evaluator = iterator.next()).evaluate(attributes).getValue()) == null ? false : subjectValue.equals(searchString))) {
        }
        return new BooleanQueryResult(isInList);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

