/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class SubstringBeforeLastEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> beforeEvaluator;

    public SubstringBeforeLastEvaluator(Evaluator<String> subject, Evaluator<String> beforeEvaluator) {
        this.subject = subject;
        this.beforeEvaluator = beforeEvaluator;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new StringQueryResult("");
        }
        String beforeValue = this.beforeEvaluator.evaluate(attributes).getValue();
        int index = subjectValue.lastIndexOf(beforeValue);
        if (index < 0) {
            return new StringQueryResult(subjectValue);
        }
        return new StringQueryResult(subjectValue.substring(0, index));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

