/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.status.history.ComponentStatusRepository;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.init.ConfigurableComponentInitializer;
import org.apache.nifi.init.ConfigurableComponentInitializerFactory;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionManager {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionManager.class);
    private static final Map<Class, Set<Class>> definitionMap = new HashMap<Class, Set<Class>>();
    private static final Map<String, List<Bundle>> classNameBundleLookup = new HashMap<String, List<Bundle>>();
    private static final Map<BundleCoordinate, Bundle> bundleCoordinateBundleLookup = new HashMap<BundleCoordinate, Bundle>();
    private static final Map<ClassLoader, Bundle> classLoaderBundleLookup = new HashMap<ClassLoader, Bundle>();
    private static final Map<String, ConfigurableComponent> tempComponentLookup = new HashMap<String, ConfigurableComponent>();
    private static final Map<String, Class<?>> requiresInstanceClassLoading = new HashMap();
    private static final Map<String, InstanceClassLoader> instanceClassloaderLookup = new ConcurrentHashMap<String, InstanceClassLoader>();

    public static void discoverExtensions(Bundle systemBundle, Set<Bundle> narBundles) {
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        ExtensionManager.loadExtensions(systemBundle);
        bundleCoordinateBundleLookup.put(systemBundle.getBundleDetails().getCoordinate(), systemBundle);
        for (Bundle bundle : narBundles) {
            ClassLoader ncl = bundle.getClassLoader();
            Thread.currentThread().setContextClassLoader(ncl);
            ExtensionManager.loadExtensions(bundle);
            bundleCoordinateBundleLookup.put(bundle.getBundleDetails().getCoordinate(), bundle);
        }
        if (currentContextClassLoader != null) {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
    }

    private static void loadExtensions(Bundle bundle) {
        for (Map.Entry<Class, Set<Class>> entry : definitionMap.entrySet()) {
            boolean isControllerService = ControllerService.class.equals((Object)entry.getKey());
            boolean isProcessor = Processor.class.equals((Object)entry.getKey());
            boolean isReportingTask = ReportingTask.class.equals((Object)entry.getKey());
            ServiceLoader serviceLoader = ServiceLoader.load(entry.getKey(), bundle.getClassLoader());
            for (Object o : serviceLoader) {
                boolean canReferenceControllerService;
                boolean registerExtension;
                if ((isControllerService || isProcessor || isReportingTask) && o instanceof ConfigurableComponent) {
                    ConfigurableComponent configurableComponent = (ConfigurableComponent)o;
                    ExtensionManager.initializeTempComponent(configurableComponent);
                    String cacheKey = ExtensionManager.getClassBundleKey(o.getClass().getCanonicalName(), bundle.getBundleDetails().getCoordinate());
                    tempComponentLookup.put(cacheKey, (ConfigurableComponent)o);
                }
                if (!(registerExtension = bundle.getClassLoader().equals(o.getClass().getClassLoader()))) continue;
                Class<?> extensionType = o.getClass();
                if (isControllerService && !ExtensionManager.checkControllerServiceEligibility(extensionType)) {
                    registerExtension = false;
                    logger.error(String.format("Skipping Controller Service %s because it is bundled with its supporting APIs and requires instance class loading.", extensionType.getName()));
                }
                boolean bl = canReferenceControllerService = (isControllerService || isProcessor || isReportingTask) && o instanceof ConfigurableComponent;
                if (canReferenceControllerService && !ExtensionManager.checkControllerServiceReferenceEligibility((ConfigurableComponent)o, bundle.getClassLoader())) {
                    registerExtension = false;
                    logger.error(String.format("Skipping component %s because it is bundled with its referenced Controller Service APIs and requires instance class loading.", extensionType.getName()));
                }
                if (!registerExtension) continue;
                ExtensionManager.registerServiceClass(o.getClass(), classNameBundleLookup, bundle, entry.getValue());
            }
            classLoaderBundleLookup.put(bundle.getClassLoader(), bundle);
        }
    }

    private static void initializeTempComponent(ConfigurableComponent configurableComponent) {
        ConfigurableComponentInitializer initializer = null;
        try {
            initializer = ConfigurableComponentInitializerFactory.createComponentInitializer(configurableComponent.getClass());
            initializer.initialize(configurableComponent);
        }
        catch (InitializationException e) {
            logger.warn(String.format("Unable to initialize component %s due to %s", configurableComponent.getClass().getName(), e.getMessage()));
        }
    }

    private static boolean checkControllerServiceReferenceEligibility(ConfigurableComponent component, ClassLoader classLoader) {
        boolean requiresInstanceClassLoading = component.getClass().isAnnotationPresent(RequiresInstanceClassLoading.class);
        HashSet<Class> cobundledApis = new HashSet<Class>();
        try (NarCloseable closeable = NarCloseable.withComponentNarLoader(component.getClass().getClassLoader());){
            List descriptors = component.getPropertyDescriptors();
            if (descriptors != null && !descriptors.isEmpty()) {
                for (PropertyDescriptor descriptor : descriptors) {
                    Class serviceApi = descriptor.getControllerServiceDefinition();
                    if (serviceApi == null || !classLoader.equals(serviceApi.getClassLoader())) continue;
                    cobundledApis.add(serviceApi);
                }
            }
        }
        if (!cobundledApis.isEmpty()) {
            logger.warn(String.format("Component %s is bundled with its referenced Controller Service APIs %s. The service APIs should not be bundled with component implementations that reference it.", component.getClass().getName(), StringUtils.join((Collection)cobundledApis.stream().map(cls -> cls.getName()).collect(Collectors.toSet()), (String)", ")));
        }
        return !requiresInstanceClassLoading || cobundledApis.isEmpty();
    }

    private static boolean checkControllerServiceEligibility(Class extensionType) {
        Class originalExtensionType = extensionType;
        ClassLoader originalExtensionClassLoader = extensionType.getClassLoader();
        boolean requiresInstanceClassLoading = extensionType.isAnnotationPresent(RequiresInstanceClassLoading.class);
        HashSet cobundledApis = new HashSet();
        while (extensionType != null) {
            for (Class<?> i : extensionType.getInterfaces()) {
                if (!originalExtensionClassLoader.equals(i.getClassLoader())) continue;
                cobundledApis.add(i);
            }
            extensionType = extensionType.getSuperclass();
        }
        if (!cobundledApis.isEmpty()) {
            logger.warn(String.format("Controller Service %s is bundled with its supporting APIs %s. The service APIs should not be bundled with the implementations.", originalExtensionType.getName(), StringUtils.join((Collection)cobundledApis.stream().map(cls -> cls.getName()).collect(Collectors.toSet()), (String)", ")));
        }
        return !requiresInstanceClassLoading || cobundledApis.isEmpty();
    }

    private static void registerServiceClass(Class<?> type, Map<String, List<Bundle>> classNameBundleMap, Bundle bundle, Set<Class> classes) {
        String className = type.getName();
        List<Bundle> registeredBundles = classNameBundleMap.get(className);
        if (registeredBundles == null) {
            registeredBundles = new ArrayList<Bundle>();
            classNameBundleMap.put(className, registeredBundles);
        }
        boolean alreadyRegistered = false;
        for (Bundle registeredBundle : registeredBundles) {
            BundleCoordinate registeredCoordinate = registeredBundle.getBundleDetails().getCoordinate();
            if (registeredCoordinate.equals((Object)bundle.getBundleDetails().getCoordinate())) {
                alreadyRegistered = true;
                break;
            }
            if (ExtensionManager.multipleVersionsAllowed(type)) continue;
            throw new IllegalStateException("Attempt was made to load " + className + " from " + bundle.getBundleDetails().getCoordinate().getCoordinate() + " but that class name is already loaded/registered from " + registeredBundle.getBundleDetails().getCoordinate() + " and multiple versions are not supported for this type");
        }
        if (!alreadyRegistered) {
            registeredBundles.add(bundle);
            classes.add(type);
            if (type.isAnnotationPresent(RequiresInstanceClassLoading.class)) {
                String cacheKey = ExtensionManager.getClassBundleKey(className, bundle.getBundleDetails().getCoordinate());
                requiresInstanceClassLoading.put(cacheKey, type);
            }
        }
    }

    private static boolean multipleVersionsAllowed(Class<?> type) {
        return Processor.class.isAssignableFrom(type) || ControllerService.class.isAssignableFrom(type) || ReportingTask.class.isAssignableFrom(type);
    }

    public static InstanceClassLoader createInstanceClassLoader(String classType, String instanceIdentifier, Bundle bundle, Set<URL> additionalUrls) {
        InstanceClassLoader instanceClassLoader;
        if (StringUtils.isEmpty((String)classType)) {
            throw new IllegalArgumentException("Class-Type is required");
        }
        if (StringUtils.isEmpty((String)instanceIdentifier)) {
            throw new IllegalArgumentException("Instance Identifier is required");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle is required");
        }
        ClassLoader bundleClassLoader = bundle.getClassLoader();
        String key = ExtensionManager.getClassBundleKey(classType, bundle.getBundleDetails().getCoordinate());
        if (requiresInstanceClassLoading.containsKey(key) && bundleClassLoader instanceof NarClassLoader) {
            Class<?> type = requiresInstanceClassLoading.get(key);
            RequiresInstanceClassLoading requiresInstanceClassLoading = type.getAnnotation(RequiresInstanceClassLoading.class);
            NarClassLoader narBundleClassLoader = (NarClassLoader)bundleClassLoader;
            logger.debug("Including ClassLoader resources from {} for component {}", new Object[]{bundle.getBundleDetails(), instanceIdentifier});
            LinkedHashSet<URL> instanceUrls = new LinkedHashSet<URL>();
            for (URL url : narBundleClassLoader.getURLs()) {
                instanceUrls.add(url);
            }
            ClassLoader ancestorClassLoader = narBundleClassLoader.getParent();
            if (requiresInstanceClassLoading.cloneAncestorResources()) {
                Bundle ancestorNarBundle;
                ConfigurableComponent component = ExtensionManager.getTempComponent(classType, bundle.getBundleDetails().getCoordinate());
                Set<BundleCoordinate> reachableApiBundles = ExtensionManager.findReachableApiBundles(component);
                while (ancestorClassLoader != null && ancestorClassLoader instanceof NarClassLoader && (ancestorNarBundle = classLoaderBundleLookup.get(ancestorClassLoader)) != null && !reachableApiBundles.contains(ancestorNarBundle.getBundleDetails().getCoordinate()) && !ancestorNarBundle.getBundleDetails().getCoordinate().getId().equals("nifi-jetty-bundle")) {
                    NarClassLoader ancestorNarClassLoader = (NarClassLoader)ancestorClassLoader;
                    for (URL url : ancestorNarClassLoader.getURLs()) {
                        instanceUrls.add(url);
                    }
                    ancestorClassLoader = ancestorNarClassLoader.getParent();
                }
            }
            instanceClassLoader = new InstanceClassLoader(instanceIdentifier, classType, instanceUrls, additionalUrls, ancestorClassLoader);
        } else {
            instanceClassLoader = new InstanceClassLoader(instanceIdentifier, classType, Collections.emptySet(), additionalUrls, bundleClassLoader);
        }
        if (logger.isTraceEnabled()) {
            for (URL url : instanceClassLoader.getURLs()) {
                logger.trace("URL resource {} for {}...", new Object[]{url.toExternalForm(), instanceIdentifier});
            }
        }
        instanceClassloaderLookup.put(instanceIdentifier, instanceClassLoader);
        return instanceClassLoader;
    }

    protected static Set<BundleCoordinate> findReachableApiBundles(ConfigurableComponent component) {
        HashSet<BundleCoordinate> reachableApiBundles = new HashSet<BundleCoordinate>();
        try (NarCloseable closeable = NarCloseable.withComponentNarLoader(component.getClass().getClassLoader());){
            List descriptors = component.getPropertyDescriptors();
            if (descriptors != null && !descriptors.isEmpty()) {
                for (PropertyDescriptor descriptor : descriptors) {
                    Class serviceApi = descriptor.getControllerServiceDefinition();
                    if (serviceApi == null || component.getClass().getClassLoader().equals(serviceApi.getClassLoader())) continue;
                    Bundle apiBundle = classLoaderBundleLookup.get(serviceApi.getClassLoader());
                    reachableApiBundles.add(apiBundle.getBundleDetails().getCoordinate());
                }
            }
        }
        return reachableApiBundles;
    }

    public static InstanceClassLoader getInstanceClassLoader(String instanceIdentifier) {
        return instanceClassloaderLookup.get(instanceIdentifier);
    }

    public static InstanceClassLoader removeInstanceClassLoader(String instanceIdentifier) {
        if (instanceIdentifier == null) {
            return null;
        }
        InstanceClassLoader classLoader = instanceClassloaderLookup.remove(instanceIdentifier);
        ExtensionManager.closeURLClassLoader(instanceIdentifier, classLoader);
        return classLoader;
    }

    public static void closeURLClassLoader(String instanceIdentifier, ClassLoader classLoader) {
        if (classLoader != null && classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            try {
                urlClassLoader.close();
            }
            catch (IOException e) {
                logger.warn("Unable to close URLClassLoader for " + instanceIdentifier);
            }
        }
    }

    public static List<Bundle> getBundles(String classType) {
        if (classType == null) {
            throw new IllegalArgumentException("Class type cannot be null");
        }
        List<Bundle> bundles = classNameBundleLookup.get(classType);
        return bundles == null ? Collections.emptyList() : new ArrayList<Bundle>(bundles);
    }

    public static Bundle getBundle(BundleCoordinate bundleCoordinate) {
        if (bundleCoordinate == null) {
            throw new IllegalArgumentException("BundleCoordinate cannot be null");
        }
        return bundleCoordinateBundleLookup.get(bundleCoordinate);
    }

    public static Bundle getBundle(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null");
        }
        return classLoaderBundleLookup.get(classLoader);
    }

    public static Set<Class> getExtensions(Class<?> definition) {
        if (definition == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        Set<Class> extensions = definitionMap.get(definition);
        return extensions == null ? Collections.emptySet() : extensions;
    }

    public static ConfigurableComponent getTempComponent(String classType, BundleCoordinate bundleCoordinate) {
        if (classType == null) {
            throw new IllegalArgumentException("Class type cannot be null");
        }
        if (bundleCoordinate == null) {
            throw new IllegalArgumentException("Bundle Coordinate cannot be null");
        }
        return tempComponentLookup.get(ExtensionManager.getClassBundleKey(classType, bundleCoordinate));
    }

    private static String getClassBundleKey(String classType, BundleCoordinate bundleCoordinate) {
        return classType + "_" + bundleCoordinate.getCoordinate();
    }

    public static void logClassLoaderMapping() {
        StringBuilder builder = new StringBuilder();
        builder.append("Extension Type Mapping to Bundle:");
        for (Map.Entry<Class, Set<Class>> entry : definitionMap.entrySet()) {
            builder.append("\n\t=== ").append(entry.getKey().getSimpleName()).append(" Type ===");
            for (Class type : entry.getValue()) {
                List<Bundle> bundles = classNameBundleLookup.containsKey(type.getName()) ? classNameBundleLookup.get(type.getName()) : Collections.emptyList();
                builder.append("\n\t").append(type.getName());
                for (Bundle bundle : bundles) {
                    String coordinate = bundle.getBundleDetails().getCoordinate().getCoordinate();
                    String workingDir = bundle.getBundleDetails().getWorkingDirectory().getPath();
                    builder.append("\n\t\t").append(coordinate).append(" || ").append(workingDir);
                }
            }
            builder.append("\n\t=== End ").append(entry.getKey().getSimpleName()).append(" types ===");
        }
        logger.info(builder.toString());
    }

    static {
        definitionMap.put(Processor.class, new HashSet());
        definitionMap.put(FlowFilePrioritizer.class, new HashSet());
        definitionMap.put(ReportingTask.class, new HashSet());
        definitionMap.put(ControllerService.class, new HashSet());
        definitionMap.put(Authorizer.class, new HashSet());
        definitionMap.put(LoginIdentityProvider.class, new HashSet());
        definitionMap.put(ProvenanceRepository.class, new HashSet());
        definitionMap.put(ComponentStatusRepository.class, new HashSet());
        definitionMap.put(FlowFileRepository.class, new HashSet());
        definitionMap.put(FlowFileSwapManager.class, new HashSet());
        definitionMap.put(ContentRepository.class, new HashSet());
        definitionMap.put(StateProvider.class, new HashSet());
    }
}

