/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.status.history.ComponentStatusRepository;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoader;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.util.NiFiProperties;

public class NarThreadContextClassLoader
extends URLClassLoader {
    static final ContextSecurityManager contextSecurityManager = new ContextSecurityManager();
    private final ClassLoader forward = ClassLoader.getSystemClassLoader();
    private static final List<Class<?>> narSpecificClasses = new ArrayList();

    private NarThreadContextClassLoader() {
        super(new URL[0]);
    }

    @Override
    public void clearAssertionStatus() {
        this.lookupClassLoader().clearAssertionStatus();
    }

    @Override
    public URL getResource(String name) {
        return this.lookupClassLoader().getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.lookupClassLoader().getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.lookupClassLoader().getResources(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.lookupClassLoader().loadClass(name);
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        this.lookupClassLoader().setClassAssertionStatus(className, enabled);
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        this.lookupClassLoader().setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.lookupClassLoader().setPackageAssertionStatus(packageName, enabled);
    }

    private ClassLoader lookupClassLoader() {
        Class<?>[] classStack;
        for (Class<?> currentClass : classStack = contextSecurityManager.getExecutionStack()) {
            Class<?> narClass = this.findNarClass(currentClass);
            if (narClass == null) continue;
            ClassLoader desiredClassLoader = narClass.getClassLoader();
            if (desiredClassLoader instanceof NarClassLoader) {
                Thread.currentThread().setContextClassLoader(desiredClassLoader);
            }
            return desiredClassLoader;
        }
        return this.forward;
    }

    private Class<?> findNarClass(Class<?> cls) {
        for (Class<?> narClass : narSpecificClasses) {
            if (narClass.isAssignableFrom(cls)) {
                return cls;
            }
            if (cls.getEnclosingClass() == null) continue;
            return this.findNarClass(cls.getEnclosingClass());
        }
        return null;
    }

    public static NarThreadContextClassLoader getInstance() {
        return SingletonHolder.instance;
    }

    public static <T> T createInstance(String implementationClassName, Class<T> typeDefinition, NiFiProperties nifiProperties) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(NarThreadContextClassLoader.getInstance());
        try {
            Constructor<T> constructor;
            block15: {
                T nsme2;
                List<Bundle> bundles = ExtensionManager.getBundles(implementationClassName);
                if (bundles.size() == 0) {
                    throw new IllegalStateException(String.format("The specified implementation class '%s' is not known to this nifi.", implementationClassName));
                }
                if (bundles.size() > 1) {
                    throw new IllegalStateException(String.format("More than one bundle was found for the specified implementation class '%s', only one is allowed.", implementationClassName));
                }
                Bundle bundle = bundles.get(0);
                ClassLoader detectedClassLoaderForType = bundle.getClassLoader();
                Class<?> rawClass = Class.forName(implementationClassName, true, detectedClassLoaderForType);
                Thread.currentThread().setContextClassLoader(detectedClassLoaderForType);
                Class<T> desiredClass = rawClass.asSubclass(typeDefinition);
                if (nifiProperties == null) {
                    T t = typeDefinition.cast(desiredClass.newInstance());
                    return t;
                }
                constructor = null;
                try {
                    constructor = desiredClass.getConstructor(NiFiProperties.class);
                }
                catch (NoSuchMethodException nsme2) {
                    try {
                        constructor = desiredClass.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException nsme22) {
                        throw new IllegalStateException("Failed to find constructor which takes NiFiProperties as argument as well as the default constructor on " + desiredClass.getName(), nsme22);
                    }
                }
                try {
                    if (constructor.getParameterTypes().length != 0) break block15;
                    nsme2 = typeDefinition.cast(constructor.newInstance(new Object[0]));
                }
                catch (InvocationTargetException ite) {
                    throw new IllegalStateException("Failed to instantiate a component due to (see target exception)", ite);
                }
                return nsme2;
            }
            T nsme2 = typeDefinition.cast(constructor.newInstance(nifiProperties));
            return nsme2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    static {
        narSpecificClasses.add(Processor.class);
        narSpecificClasses.add(FlowFilePrioritizer.class);
        narSpecificClasses.add(ReportingTask.class);
        narSpecificClasses.add(Validator.class);
        narSpecificClasses.add(InputStreamCallback.class);
        narSpecificClasses.add(OutputStreamCallback.class);
        narSpecificClasses.add(StreamCallback.class);
        narSpecificClasses.add(ControllerService.class);
        narSpecificClasses.add(Authorizer.class);
        narSpecificClasses.add(LoginIdentityProvider.class);
        narSpecificClasses.add(ProvenanceRepository.class);
        narSpecificClasses.add(ComponentStatusRepository.class);
        narSpecificClasses.add(FlowFileRepository.class);
        narSpecificClasses.add(FlowFileSwapManager.class);
        narSpecificClasses.add(ContentRepository.class);
        narSpecificClasses.add(StateProvider.class);
    }

    static class ContextSecurityManager
    extends SecurityManager {
        ContextSecurityManager() {
        }

        Class<?>[] getExecutionStack() {
            return this.getClassContext();
        }
    }

    private static class SingletonHolder {
        public static final NarThreadContextClassLoader instance = new NarThreadContextClassLoader();

        private SingletonHolder() {
        }
    }
}

