/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceClassLoader
extends URLClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(InstanceClassLoader.class);
    private final String identifier;
    private final String instanceType;
    private final Set<URL> instanceUrls;
    private final Set<URL> additionalResourceUrls;

    public InstanceClassLoader(String identifier, String type, Set<URL> instanceUrls, Set<URL> additionalResourceUrls, ClassLoader parent) {
        super(InstanceClassLoader.combineURLs(instanceUrls, additionalResourceUrls), parent);
        this.identifier = identifier;
        this.instanceType = type;
        this.instanceUrls = Collections.unmodifiableSet(instanceUrls == null ? Collections.emptySet() : new LinkedHashSet<URL>(instanceUrls));
        this.additionalResourceUrls = Collections.unmodifiableSet(additionalResourceUrls == null ? Collections.emptySet() : new LinkedHashSet<URL>(additionalResourceUrls));
    }

    private static URL[] combineURLs(Set<URL> instanceUrls, Set<URL> additionalResourceUrls) {
        LinkedHashSet<URL> allUrls = new LinkedHashSet<URL>();
        if (instanceUrls != null) {
            allUrls.addAll(instanceUrls);
        }
        if (additionalResourceUrls != null) {
            allUrls.addAll(additionalResourceUrls);
        }
        return allUrls.toArray(new URL[allUrls.size()]);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Set<URL> getInstanceUrls() {
        return this.instanceUrls;
    }

    public Set<URL> getAdditionalResourceUrls() {
        return this.additionalResourceUrls;
    }
}

