/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreUtils {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreUtils.class);
    public static final String SUN_PROVIDER_NAME = "SUN";

    public static String getKeyStoreProvider(String keyStoreType) {
        if (KeystoreType.PKCS12.toString().equalsIgnoreCase(keyStoreType)) {
            return "BC";
        }
        if (KeystoreType.JKS.toString().equalsIgnoreCase(keyStoreType)) {
            return SUN_PROVIDER_NAME;
        }
        return null;
    }

    public static KeyStore getKeyStore(String keyStoreType) throws KeyStoreException {
        String keyStoreProvider = KeyStoreUtils.getKeyStoreProvider(keyStoreType);
        if (StringUtils.isNotEmpty((CharSequence)keyStoreProvider)) {
            try {
                return KeyStore.getInstance(keyStoreType, keyStoreProvider);
            }
            catch (Exception e) {
                logger.error("Unable to load " + keyStoreProvider + " " + keyStoreType + " keystore.  This may cause issues getting trusted CA certificates as well as Certificate Chains for use in TLS.", (Throwable)e);
            }
        }
        return KeyStore.getInstance(keyStoreType);
    }

    public static KeyStore getTrustStore(String trustStoreType) throws KeyStoreException {
        if (KeystoreType.PKCS12.toString().equalsIgnoreCase(trustStoreType)) {
            logger.warn(trustStoreType + " truststores are deprecated.  " + KeystoreType.JKS.toString() + " is preferred.");
        }
        return KeyStoreUtils.getKeyStore(trustStoreType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStoreValid(URL keystore, KeystoreType keystoreType, char[] password) {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        if (keystoreType == null) {
            throw new IllegalArgumentException("Keystore type may not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password may not be null");
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(keystore.openStream());
            KeyStore ks = KeyStoreUtils.getKeyStore(keystoreType.name());
            ks.load(bis, password);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    logger.warn("Failed to close input stream", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isKeyPasswordCorrect(URL keystore, KeystoreType keystoreType, char[] password, char[] keyPassword) {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        if (keystoreType == null) {
            throw new IllegalArgumentException("Keystore type may not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password may not be null");
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(keystore.openStream());
            KeyStore ks = KeyStoreUtils.getKeyStore(keystoreType.name());
            ks.load(bis, password);
            String alias = ks.aliases().nextElement();
            try {
                Key privateKeyEntry = ks.getKey(alias, keyPassword);
                boolean bl = true;
                return bl;
            }
            catch (UnrecoverableKeyException e) {
                boolean bl;
                block20: {
                    logger.warn("Tried to access a key in keystore " + keystore + " with a key password that failed");
                    bl = false;
                    if (bis == null) break block20;
                    try {
                        bis.close();
                    }
                    catch (IOException ioe) {
                        logger.warn("Failed to close input stream", (Throwable)ioe);
                    }
                }
                return bl;
                catch (Exception e2) {
                    boolean bl2 = false;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    logger.warn("Failed to close input stream", (Throwable)ioe);
                }
            }
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

