/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.stream.io.StreamUtils;

public class CipherUtility {
    public static final int BUFFER_SIZE = 65536;
    private static final Pattern KEY_LENGTH_PATTERN = Pattern.compile("([\\d]+)BIT");
    private static final Map<String, Integer> MAX_PASSWORD_LENGTH_BY_ALGORITHM;
    private static final int DEFAULT_MAX_ALLOWED_KEY_LENGTH = 128;

    public static String parseCipherFromAlgorithm(String algorithm) {
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            return algorithm;
        }
        String formattedAlgorithm = algorithm.toUpperCase();
        String AES = "AES";
        String TDES = "TRIPLEDES";
        String TDES_ALTERNATE = "DESEDE";
        String DES = "DES";
        String RC4 = "RC4";
        String RC2 = "RC2";
        String TWOFISH = "TWOFISH";
        List<String> SYMMETRIC_CIPHERS = Arrays.asList("AES", "TRIPLEDES", "DESEDE", "DES", "RC4", "RC2", "TWOFISH");
        String ACTUAL_TDES_CIPHER = "DESede";
        for (String cipher : SYMMETRIC_CIPHERS) {
            if (!formattedAlgorithm.contains(cipher)) continue;
            if (cipher.equals("TRIPLEDES") || cipher.equals("DESEDE")) {
                return "DESede";
            }
            return cipher;
        }
        return algorithm;
    }

    public static int parseKeyLengthFromAlgorithm(String algorithm) {
        int keyLength = CipherUtility.parseActualKeyLengthFromAlgorithm(algorithm);
        if (keyLength != -1) {
            return keyLength;
        }
        String cipher = CipherUtility.parseCipherFromAlgorithm(algorithm);
        return CipherUtility.getDefaultKeyLengthForCipher(cipher);
    }

    private static int parseActualKeyLengthFromAlgorithm(String algorithm) {
        Matcher matcher = KEY_LENGTH_PATTERN.matcher(algorithm);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    public static boolean isValidKeyLength(int keyLength, String cipher) {
        if (StringUtils.isEmpty((CharSequence)cipher)) {
            return false;
        }
        return CipherUtility.getValidKeyLengthsForAlgorithm(cipher).contains(keyLength);
    }

    public static boolean isValidKeyLengthForAlgorithm(int keyLength, String algorithm) {
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            return false;
        }
        return CipherUtility.getValidKeyLengthsForAlgorithm(algorithm).contains(keyLength);
    }

    public static List<Integer> getValidKeyLengthsForAlgorithm(String algorithm) {
        ArrayList<Integer> validKeyLengths = new ArrayList<Integer>();
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            return validKeyLengths;
        }
        int keyLength = CipherUtility.parseActualKeyLengthFromAlgorithm(algorithm);
        if (keyLength != -1) {
            validKeyLengths.add(keyLength);
            return validKeyLengths;
        }
        String cipher = CipherUtility.parseCipherFromAlgorithm(algorithm);
        switch (cipher.toUpperCase()) {
            case "DESEDE": {
                return Arrays.asList(56, 64, 112, 128, 168, 192);
            }
            case "DES": {
                return Arrays.asList(56, 64);
            }
            case "RC2": 
            case "RC4": 
            case "RC5": {
                for (int i = 40; i <= 2048; ++i) {
                    validKeyLengths.add(i);
                }
                return validKeyLengths;
            }
            case "AES": 
            case "TWOFISH": {
                return Arrays.asList(128, 192, 256);
            }
        }
        return validKeyLengths;
    }

    private static int getDefaultKeyLengthForCipher(String cipher) {
        if (StringUtils.isEmpty((CharSequence)cipher)) {
            return -1;
        }
        switch (cipher = cipher.toUpperCase()) {
            case "DESEDE": {
                return 112;
            }
            case "DES": {
                return 64;
            }
        }
        return 128;
    }

    public static void processStreams(Cipher cipher, InputStream in, OutputStream out) {
        try {
            int len;
            byte[] buffer = new byte[65536];
            while ((len = in.read(buffer)) > 0) {
                byte[] decryptedBytes = cipher.update(buffer, 0, len);
                if (decryptedBytes == null) continue;
                out.write(decryptedBytes);
            }
            out.write(cipher.doFinal());
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public static byte[] readBytesFromInputStream(InputStream in, String label, int limit, byte[] delimiter) throws IOException, ProcessException {
        if (in == null) {
            throw new IllegalArgumentException("Cannot read " + label + " from null InputStream");
        }
        in.mark(limit);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        byte[] stoppedBy = StreamUtils.copyExclusive((InputStream)in, (OutputStream)bytesOut, (int)(limit + delimiter.length), (byte[][])new byte[][]{delimiter});
        if (stoppedBy != null) {
            byte[] bytes = bytesOut.toByteArray();
            return bytes;
        }
        in.reset();
        return null;
    }

    public static void writeBytesToOutputStream(OutputStream out, byte[] value, String label, byte[] delimiter) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Cannot write " + label + " to null OutputStream");
        }
        out.write(value);
        out.write(delimiter);
    }

    public static String encodeBase64NoPadding(byte[] bytes) {
        String base64UrlNoPadding = Base64.encodeBase64URLSafeString((byte[])bytes);
        base64UrlNoPadding = base64UrlNoPadding.replaceAll("-", "+");
        base64UrlNoPadding = base64UrlNoPadding.replaceAll("_", "/");
        return base64UrlNoPadding;
    }

    public static boolean passwordLengthIsValidForAlgorithmOnLimitedStrengthCrypto(int passwordLength, EncryptionMethod encryptionMethod) {
        if (encryptionMethod == null) {
            throw new IllegalArgumentException("Cannot evaluate an empty encryption method algorithm");
        }
        return passwordLength <= CipherUtility.getMaximumPasswordLengthForAlgorithmOnLimitedStrengthCrypto(encryptionMethod);
    }

    public static int getMaximumPasswordLengthForAlgorithmOnLimitedStrengthCrypto(EncryptionMethod encryptionMethod) {
        if (encryptionMethod == null) {
            throw new IllegalArgumentException("Cannot evaluate an empty encryption method algorithm");
        }
        return MAX_PASSWORD_LENGTH_BY_ALGORITHM.getOrDefault(encryptionMethod.getAlgorithm(), -1);
    }

    public static boolean isUnlimitedStrengthCryptoSupported() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public static boolean isPBECipher(String algorithm) {
        EncryptionMethod em = EncryptionMethod.forAlgorithm(algorithm);
        return em != null && em.isPBECipher();
    }

    public static boolean isKeyedCipher(String algorithm) {
        EncryptionMethod em = EncryptionMethod.forAlgorithm(algorithm);
        return em != null && em.isKeyedCipher();
    }

    public static Cipher initPBECipher(String algorithm, String provider, String password, byte[] salt, int iterationCount, boolean encryptMode) throws IllegalArgumentException {
        try {
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
            SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm, provider);
            SecretKey tempKey = factory.generateSecret(pbeKeySpec);
            PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, iterationCount);
            Cipher cipher = Cipher.getInstance(algorithm, provider);
            cipher.init(encryptMode ? 1 : 2, (Key)tempKey, parameterSpec);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("One or more parameters to initialize the PBE cipher were invalid", e);
        }
    }

    public static int getIterationCountForAlgorithm(String algorithm) {
        int iterationCount = 0;
        if (algorithm.matches("DES|RC|SHAA|SHA256")) {
            iterationCount = 1000;
        }
        return iterationCount;
    }

    public static int getSaltLengthForAlgorithm(String algorithm) {
        int saltLength = 16;
        if (algorithm.contains("DES") || algorithm.contains("RC")) {
            saltLength = 8;
        }
        return saltLength;
    }

    static {
        HashMap<String, Integer> aMap = new HashMap<String, Integer>();
        aMap.put("PBEWITHMD5AND128BITAES-CBC-OPENSSL", 16);
        aMap.put("PBEWITHMD5AND192BITAES-CBC-OPENSSL", 16);
        aMap.put("PBEWITHMD5AND256BITAES-CBC-OPENSSL", 16);
        aMap.put("PBEWITHMD5ANDDES", 16);
        aMap.put("PBEWITHMD5ANDRC2", 16);
        aMap.put("PBEWITHSHA1ANDRC2", 16);
        aMap.put("PBEWITHSHA1ANDDES", 16);
        aMap.put("PBEWITHSHAAND128BITAES-CBC-BC", 7);
        aMap.put("PBEWITHSHAAND192BITAES-CBC-BC", 7);
        aMap.put("PBEWITHSHAAND256BITAES-CBC-BC", 7);
        aMap.put("PBEWITHSHAAND40BITRC2-CBC", 7);
        aMap.put("PBEWITHSHAAND128BITRC2-CBC", 7);
        aMap.put("PBEWITHSHAAND40BITRC4", 7);
        aMap.put("PBEWITHSHAAND128BITRC4", 7);
        aMap.put("PBEWITHSHA256AND128BITAES-CBC-BC", 7);
        aMap.put("PBEWITHSHA256AND192BITAES-CBC-BC", 7);
        aMap.put("PBEWITHSHA256AND256BITAES-CBC-BC", 7);
        aMap.put("PBEWITHSHAAND2-KEYTRIPLEDES-CBC", 7);
        aMap.put("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", 7);
        aMap.put("PBEWITHSHAANDTWOFISH-CBC", 7);
        MAX_PASSWORD_LENGTH_BY_ALGORITHM = Collections.unmodifiableMap(aMap);
    }
}

