/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.repository.config;

import java.util.Map;
import org.apache.nifi.security.repository.RepositoryType;
import org.apache.nifi.security.repository.config.ContentRepositoryEncryptionConfiguration;
import org.apache.nifi.security.repository.config.FlowFileRepositoryEncryptionConfiguration;
import org.apache.nifi.security.repository.config.ProvenanceRepositoryEncryptionConfiguration;
import org.apache.nifi.util.NiFiProperties;

public abstract class RepositoryEncryptionConfiguration {
    String keyProviderImplementation;
    String keyProviderLocation;
    String encryptionKeyId;
    Map<String, String> encryptionKeys;
    String repositoryImplementation;
    RepositoryType repositoryType;

    public String getKeyProviderImplementation() {
        return this.keyProviderImplementation;
    }

    public String getKeyProviderLocation() {
        return this.keyProviderLocation;
    }

    public String getEncryptionKeyId() {
        return this.encryptionKeyId;
    }

    public Map<String, String> getEncryptionKeys() {
        return this.encryptionKeys;
    }

    public String getRepositoryImplementation() {
        return this.repositoryImplementation;
    }

    public RepositoryType getRepositoryType() {
        return this.repositoryType;
    }

    public static RepositoryEncryptionConfiguration fromNiFiProperties(NiFiProperties niFiProperties, RepositoryType repositoryType) {
        switch (repositoryType) {
            case CONTENT: {
                return new ContentRepositoryEncryptionConfiguration(niFiProperties);
            }
            case PROVENANCE: {
                return new ProvenanceRepositoryEncryptionConfiguration(niFiProperties);
            }
            case FLOWFILE: {
                return new FlowFileRepositoryEncryptionConfiguration(niFiProperties);
            }
        }
        throw new IllegalArgumentException("The specified repository does not support encryption");
    }
}

