/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.repository.stream.aes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.apache.nifi.security.kms.CryptoUtils;
import org.apache.nifi.security.kms.EncryptionException;
import org.apache.nifi.security.repository.AbstractAESEncryptor;
import org.apache.nifi.security.repository.RepositoryEncryptorUtils;
import org.apache.nifi.security.repository.RepositoryObjectEncryptionMetadata;
import org.apache.nifi.security.repository.StreamingEncryptionMetadata;
import org.apache.nifi.security.repository.stream.RepositoryObjectStreamEncryptor;
import org.apache.nifi.security.util.EncryptionMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryObjectAESCTREncryptor
extends AbstractAESEncryptor
implements RepositoryObjectStreamEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryObjectAESCTREncryptor.class);
    private static final byte[] EM_START_SENTINEL = new byte[]{0, 0};
    private static String ALGORITHM = "AES/CTR/NoPadding";
    private static final String VERSION = "v1";
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("v1");

    @Override
    public OutputStream encrypt(OutputStream plainStream, String streamId, String keyId) throws EncryptionException {
        if (plainStream == null || CryptoUtils.isEmpty(keyId)) {
            throw new EncryptionException("The streaming repository object and key ID cannot be missing");
        }
        if (this.keyProvider == null || !this.keyProvider.keyExists(keyId)) {
            throw new EncryptionException("The requested key ID is not available");
        }
        byte[] ivBytes = new byte[16];
        new SecureRandom().nextBytes(ivBytes);
        try {
            logger.debug("Encrypting streaming repository object " + streamId + " with key ID " + keyId);
            Cipher cipher = RepositoryEncryptorUtils.initCipher(this.aesKeyedCipherProvider, EncryptionMethod.forAlgorithm(ALGORITHM), 1, this.keyProvider.getKey(keyId), ivBytes);
            ivBytes = cipher.getIV();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(plainStream, cipher);
            StreamingEncryptionMetadata metadata = new StreamingEncryptionMetadata(keyId, ALGORITHM, ivBytes, VERSION);
            byte[] serializedEncryptionMetadata = RepositoryEncryptorUtils.serializeEncryptionMetadata(metadata);
            plainStream.write(EM_START_SENTINEL);
            plainStream.write(serializedEncryptionMetadata);
            plainStream.flush();
            logger.debug("Encrypted streaming repository object " + streamId + " with key ID " + keyId);
            return cipherOutputStream;
        }
        catch (IOException | KeyManagementException | EncryptionException e) {
            String msg = "Encountered an exception encrypting streaming repository object " + streamId;
            logger.error(msg, (Throwable)e);
            throw new EncryptionException(msg, e);
        }
    }

    @Override
    public InputStream decrypt(InputStream encryptedInputStream, String streamId) throws EncryptionException {
        RepositoryObjectEncryptionMetadata metadata = RepositoryObjectAESCTREncryptor.prepareObjectForDecryption(encryptedInputStream, streamId, "streaming repository object", SUPPORTED_VERSIONS);
        if (this.keyProvider == null || !this.keyProvider.keyExists(metadata.keyId) || CryptoUtils.isEmpty(metadata.keyId)) {
            throw new EncryptionException("The requested key ID " + metadata.keyId + " is not available");
        }
        try {
            logger.debug("Decrypting streaming repository object with ID " + streamId + " with key ID " + metadata.keyId);
            EncryptionMethod method = EncryptionMethod.forAlgorithm(metadata.algorithm);
            Cipher cipher = RepositoryEncryptorUtils.initCipher(this.aesKeyedCipherProvider, method, 2, this.keyProvider.getKey(metadata.keyId), metadata.ivBytes);
            CipherInputStream cipherInputStream = new CipherInputStream(encryptedInputStream, cipher);
            logger.debug("Decrypted streaming repository object with ID " + streamId + " with key ID " + metadata.keyId);
            return cipherInputStream;
        }
        catch (KeyManagementException | EncryptionException e) {
            String msg = "Encountered an exception decrypting streaming repository object with ID " + streamId;
            logger.error(msg, (Throwable)e);
            throw new EncryptionException(msg, e);
        }
    }

    @Override
    public String getNextKeyId() throws KeyManagementException {
        return null;
    }
}

