/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.kms;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.nifi.security.kms.FileBasedKeyProvider;
import org.apache.nifi.security.kms.StaticKeyProvider;
import org.apache.nifi.security.repository.config.RepositoryEncryptionConfiguration;
import org.apache.nifi.util.NiFiBootstrapUtils;
import org.apache.nifi.util.StringUtils;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtils {
    private static final Logger logger = LoggerFactory.getLogger(CryptoUtils.class);
    public static final String STATIC_KEY_PROVIDER_CLASS_NAME = "org.apache.nifi.security.kms.StaticKeyProvider";
    public static final String FILE_BASED_KEY_PROVIDER_CLASS_NAME = "org.apache.nifi.security.kms.FileBasedKeyProvider";
    public static final String KEY_STORE_KEY_PROVIDER_CLASS_NAME = "org.apache.nifi.security.kms.KeyStoreKeyProvider";
    public static final String LEGACY_SKP_FQCN = "org.apache.nifi.provenance.StaticKeyProvider";
    public static final String LEGACY_FBKP_FQCN = "org.apache.nifi.provenance.FileBasedKeyProvider";
    private static final Pattern HEX_PATTERN = Pattern.compile("(?i)^[0-9a-f]+$");
    private static final List<Integer> UNLIMITED_KEY_LENGTHS = Arrays.asList(32, 48, 64);
    public static final String ENCRYPTED_FSR_CLASS_NAME = "org.apache.nifi.controller.repository.crypto.EncryptedFileSystemRepository";
    public static final String EWAFFR_CLASS_NAME = "org.apache.nifi.controller.repository.crypto.EncryptedWriteAheadFlowFileRepository";

    public static boolean isUnlimitedStrengthCryptoAvailable() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Tried to determine if unlimited strength crypto is available but the AES algorithm is not available");
            return false;
        }
    }

    public static boolean isEmpty(String src) {
        return src == null || src.trim().isEmpty();
    }

    public static byte[] concatByteArrays(byte[] ... arrays) {
        int totalByteLength = 0;
        for (byte[] bytes : arrays) {
            totalByteLength += bytes.length;
        }
        byte[] totalBytes = new byte[totalByteLength];
        int currentLength = 0;
        for (byte[] bytes : arrays) {
            System.arraycopy(bytes, 0, totalBytes, currentLength, bytes.length);
            currentLength += bytes.length;
        }
        return totalBytes;
    }

    public static boolean isValidRepositoryEncryptionConfiguration(RepositoryEncryptionConfiguration rec) {
        return CryptoUtils.isValidKeyProvider(rec.getKeyProviderImplementation(), rec.getKeyProviderLocation(), rec.getEncryptionKeyId(), rec.getEncryptionKeys());
    }

    public static boolean isValidKeyProvider(String keyProviderImplementation, String keyProviderLocation, String keyId, Map<String, String> encryptionKeys) {
        try {
            keyProviderImplementation = CryptoUtils.handleLegacyPackages(keyProviderImplementation);
        }
        catch (KeyManagementException e) {
            logger.warn("Key Provider [{}] Validation Failed: {}", (Object)keyProviderImplementation, (Object)e.getMessage());
            return false;
        }
        switch (keyProviderImplementation) {
            case "org.apache.nifi.security.kms.StaticKeyProvider": {
                if (encryptionKeys == null) {
                    return false;
                }
                boolean everyKeyValid = encryptionKeys.values().stream().allMatch(CryptoUtils::keyIsValid);
                return everyKeyValid && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)keyId);
            }
            case "org.apache.nifi.security.kms.FileBasedKeyProvider": 
            case "org.apache.nifi.security.kms.KeyStoreKeyProvider": {
                Path keyProviderPath = Paths.get(keyProviderLocation, new String[0]);
                return Files.isReadable(keyProviderPath) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)keyId);
            }
        }
        logger.warn("Validation Failed: Key Provider [{}] Location [{}] Key ID [{}]", new Object[]{keyProviderImplementation, keyProviderLocation, keyId});
        return false;
    }

    static String handleLegacyPackages(String implementationClassName) throws KeyManagementException {
        if (StringUtils.isBlank((String)implementationClassName)) {
            throw new KeyManagementException("Invalid key provider implementation provided: " + implementationClassName);
        }
        if (implementationClassName.equalsIgnoreCase(LEGACY_SKP_FQCN)) {
            return StaticKeyProvider.class.getName();
        }
        if (implementationClassName.equalsIgnoreCase(LEGACY_FBKP_FQCN)) {
            return FileBasedKeyProvider.class.getName();
        }
        return implementationClassName;
    }

    public static boolean keyIsValid(String encryptionKeyHex) {
        return CryptoUtils.isHexString(encryptionKeyHex) && (CryptoUtils.isUnlimitedStrengthCryptoAvailable() ? UNLIMITED_KEY_LENGTHS.contains(encryptionKeyHex.length()) : encryptionKeyHex.length() == 32);
    }

    public static boolean isHexString(String hexString) {
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)hexString) && HEX_PATTERN.matcher(hexString).matches();
    }

    public static SecretKey getRootKey() throws KeyManagementException {
        try {
            String rootKeyHex = NiFiBootstrapUtils.extractKeyFromBootstrapFile();
            return new SecretKeySpec(Hex.decode((String)rootKeyHex), "AES");
        }
        catch (IOException | DecoderException e) {
            logger.error("Encountered an error: ", e);
            throw new KeyManagementException(e);
        }
    }

    public static boolean constantTimeEquals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return b != null && CryptoUtils.constantTimeEquals(a.getBytes(StandardCharsets.UTF_8), b.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean constantTimeEquals(char[] a, char[] b) {
        return CryptoUtils.constantTimeEquals(CryptoUtils.convertCharsToBytes(a), CryptoUtils.convertCharsToBytes(b));
    }

    public static boolean constantTimeEquals(byte[] a, byte[] b) {
        return MessageDigest.isEqual(a, b);
    }

    private static byte[] convertCharsToBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        return Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
    }
}

