/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(SslContextFactory.class);

    public static SSLContext createSslContext(TlsConfiguration tlsConfiguration) throws TlsException {
        if (TlsConfiguration.isEmpty((TlsConfiguration)tlsConfiguration)) {
            logger.debug("Cannot create SSLContext from empty TLS configuration; returning null");
            return null;
        }
        if (tlsConfiguration.isKeystorePopulated() && !tlsConfiguration.isTruststorePopulated()) {
            logger.error("The TLS config keystore properties were populated but the truststore properties were not");
            if (logger.isDebugEnabled()) {
                logger.debug("Provided TLS config: {}", (Object)tlsConfiguration);
            }
            throw new TlsException("Truststore properties are required if keystore properties are present");
        }
        TrustManager[] trustManagers = SslContextFactory.getTrustManagers(tlsConfiguration);
        return SslContextFactory.createSslContext(tlsConfiguration, trustManagers);
    }

    public static SSLContext createSslContext(TlsConfiguration tlsConfiguration, TrustManager[] trustManagers) throws TlsException {
        if (TlsConfiguration.isEmpty((TlsConfiguration)tlsConfiguration)) {
            logger.debug("Cannot create SSLContext from empty TLS configuration; returning null");
            return null;
        }
        KeyManager[] keyManagers = SslContextFactory.getKeyManagers(tlsConfiguration);
        return SslContextFactory.initializeSSLContext(tlsConfiguration, keyManagers, trustManagers);
    }

    public static X509TrustManager getX509TrustManager(TlsConfiguration tlsConfiguration) throws TlsException {
        TrustManager[] trustManagers = SslContextFactory.getTrustManagers(tlsConfiguration);
        if (trustManagers == null) {
            return null;
        }
        Optional<X509TrustManager> x509TrustManager = Arrays.stream(trustManagers).filter(tm -> tm instanceof X509TrustManager).map(tm -> (X509TrustManager)tm).findFirst();
        return x509TrustManager.orElse(null);
    }

    public static SSLSocketFactory createSSLSocketFactory(TlsConfiguration tlsConfiguration) throws TlsException {
        SSLContext sslContext = SslContextFactory.createSslContext(tlsConfiguration);
        if (sslContext == null) {
            if (!TlsConfiguration.isEmpty((TlsConfiguration)tlsConfiguration)) {
                logger.error("The SSLContext could not be formed from the provided TLS configuration. Check the provided keystore and truststore properties");
            }
            return null;
        }
        return sslContext.getSocketFactory();
    }

    protected static KeyManager[] getKeyManagers(TlsConfiguration tlsConfiguration) throws TlsException {
        KeyManager[] keyManagers = null;
        if (tlsConfiguration.isKeystoreValid()) {
            KeyManagerFactory keyManagerFactory = KeyStoreUtils.loadKeyManagerFactory(tlsConfiguration);
            keyManagers = keyManagerFactory.getKeyManagers();
        } else {
            if (tlsConfiguration.isAnyKeystorePopulated()) {
                logger.warn("Some keystore properties are populated ({}, {}, {}, {}) but not valid", (Object[])tlsConfiguration.getKeystorePropertiesForLogging());
                throw new TlsException("The keystore properties are not valid");
            }
            logger.debug("The keystore properties are not populated");
        }
        return keyManagers;
    }

    public static TrustManager[] getTrustManagers(TlsConfiguration tlsConfiguration) throws TlsException {
        TrustManager[] trustManagers = null;
        if (tlsConfiguration.isTruststoreValid()) {
            TrustManagerFactory trustManagerFactory = KeyStoreUtils.loadTrustManagerFactory(tlsConfiguration);
            trustManagers = trustManagerFactory.getTrustManagers();
        } else {
            if (tlsConfiguration.isAnyTruststorePopulated()) {
                logger.warn("Some truststore properties are populated ({}, {}, {}) but not valid", (Object[])tlsConfiguration.getTruststorePropertiesForLogging());
                throw new TlsException("The truststore properties are not valid");
            }
            logger.debug("The truststore properties are not populated");
        }
        return trustManagers;
    }

    private static SSLContext initializeSSLContext(TlsConfiguration tlsConfiguration, KeyManager[] keyManagers, TrustManager[] trustManagers) throws TlsException {
        try {
            SSLContext sslContext = SSLContext.getInstance(tlsConfiguration.getProtocol());
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.error("Encountered an error creating SSLContext from TLS configuration ({}): {}", (Object)tlsConfiguration.toString(), (Object)e.getLocalizedMessage());
            throw new TlsException("Error creating SSL context", (Throwable)e);
        }
    }
}

