/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.nifi.properties.AbstractBootstrapPropertiesLoader;
import org.apache.nifi.properties.AbstractSensitivePropertyProvider;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.vault.hashicorp.HashiCorpVaultCommunicationService;
import org.apache.nifi.vault.hashicorp.StandardHashiCorpVaultCommunicationService;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultConfiguration;
import org.springframework.core.env.PropertySource;

public abstract class AbstractHashiCorpVaultSensitivePropertyProvider
extends AbstractSensitivePropertyProvider {
    private static final String VAULT_PREFIX = "vault";
    private final String path;
    private final HashiCorpVaultCommunicationService vaultCommunicationService;
    private final BootstrapProperties vaultBootstrapProperties;

    AbstractHashiCorpVaultSensitivePropertyProvider(BootstrapProperties bootstrapProperties) {
        super(bootstrapProperties);
        String vaultBootstrapConfFilename = bootstrapProperties.getProperty(BootstrapProperties.BootstrapPropertyKey.HASHICORP_VAULT_SENSITIVE_PROPERTY_PROVIDER_CONF).orElse(null);
        this.vaultBootstrapProperties = AbstractHashiCorpVaultSensitivePropertyProvider.getVaultBootstrapProperties(vaultBootstrapConfFilename);
        this.path = this.getSecretsEnginePath(this.vaultBootstrapProperties);
        if (this.hasRequiredVaultProperties()) {
            try {
                this.vaultCommunicationService = new StandardHashiCorpVaultCommunicationService(new PropertySource[]{this.getVaultPropertySource(vaultBootstrapConfFilename)});
            }
            catch (IOException e) {
                throw new SensitivePropertyProtectionException("Error configuring HashiCorpVaultCommunicationService", e);
            }
        } else {
            this.vaultCommunicationService = null;
        }
    }

    protected abstract String getSecretsEnginePath(BootstrapProperties var1);

    private static BootstrapProperties getVaultBootstrapProperties(String vaultBootstrapConfFilename) {
        BootstrapProperties vaultBootstrapProperties;
        if (vaultBootstrapConfFilename != null) {
            try {
                vaultBootstrapProperties = AbstractBootstrapPropertiesLoader.loadBootstrapProperties((Path)Paths.get(vaultBootstrapConfFilename, new String[0]), (String)VAULT_PREFIX);
            }
            catch (IOException e) {
                throw new SensitivePropertyProtectionException("Could not load " + vaultBootstrapConfFilename, e);
            }
        } else {
            vaultBootstrapProperties = null;
        }
        return vaultBootstrapProperties;
    }

    private PropertySource<?> getVaultPropertySource(String vaultBootstrapConfFilename) throws IOException {
        return HashiCorpVaultConfiguration.createPropertiesFileSource((String)vaultBootstrapConfFilename);
    }

    protected String getPath() {
        return this.path;
    }

    protected HashiCorpVaultCommunicationService getVaultCommunicationService() {
        if (this.vaultCommunicationService == null) {
            throw new SensitivePropertyProtectionException(this.getIdentifierKey() + " protection scheme is not fully configured in hashicorp-vault-bootstrap.conf");
        }
        return this.vaultCommunicationService;
    }

    @Override
    public boolean isSupported() {
        return this.hasRequiredVaultProperties();
    }

    protected BootstrapProperties getVaultBootstrapProperties() {
        return this.vaultBootstrapProperties;
    }

    private boolean hasRequiredVaultProperties() {
        return this.vaultBootstrapProperties != null && this.vaultBootstrapProperties.getProperty(HashiCorpVaultConfiguration.VaultConfigurationKey.URI.getKey()) != null && this.hasRequiredSecretsEngineProperties(this.vaultBootstrapProperties);
    }

    protected abstract boolean hasRequiredSecretsEngineProperties(BootstrapProperties var1);

    @Override
    public String getIdentifierKey() {
        return this.getProtectionScheme().getIdentifier(this.path);
    }
}

