/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.properties.ApplicationProperties;
import org.apache.nifi.properties.MultipleSensitivePropertyProtectionException;
import org.apache.nifi.properties.ProtectedProperties;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProtector;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationPropertiesProtector<T extends ProtectedProperties<U>, U extends ApplicationProperties>
implements SensitivePropertyProtector<T, U> {
    public static final String PROTECTED_KEY_SUFFIX = ".protected";
    private static final Logger logger = LoggerFactory.getLogger(ApplicationPropertiesProtector.class);
    private T protectedProperties;
    private Map<String, SensitivePropertyProvider> localProviderCache = new HashMap<String, SensitivePropertyProvider>();

    public ApplicationPropertiesProtector(T protectedProperties) {
        this.protectedProperties = protectedProperties;
        logger.debug("Loaded {} properties (including {} protection schemes) into {}", new Object[]{this.getPropertyKeysIncludingProtectionSchemes().size(), this.getProtectedPropertyKeys().size(), this.getClass().getName()});
    }

    public static String getProtectionKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Cannot find protection key for null key");
        }
        return key + PROTECTED_KEY_SUFFIX;
    }

    @Override
    public Set<String> getPropertyKeys() {
        Set<String> filteredKeys = this.getPropertyKeysIncludingProtectionSchemes();
        filteredKeys.removeIf(p -> p.endsWith(PROTECTED_KEY_SUFFIX));
        return filteredKeys;
    }

    @Override
    public int size() {
        return this.getPropertyKeys().size();
    }

    @Override
    public Set<String> getPropertyKeysIncludingProtectionSchemes() {
        return this.protectedProperties.getApplicationProperties().getPropertyKeys();
    }

    private static List<String> splitMultipleProperties(String multipleProperties) {
        if (multipleProperties == null || multipleProperties.trim().isEmpty()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> properties = new ArrayList<String>(Arrays.asList(multipleProperties.split("\\s*[,;]\\s*")));
        for (int i = 0; i < properties.size(); ++i) {
            properties.set(i, ((String)properties.get(i)).trim());
        }
        return properties;
    }

    private String getProperty(String key) {
        return this.protectedProperties.getApplicationProperties().getProperty(key);
    }

    private String getAdditionalSensitivePropertiesKeys() {
        return this.getProperty(this.protectedProperties.getAdditionalSensitivePropertiesKeysName());
    }

    private String getAdditionalSensitivePropertiesKeysName() {
        return this.protectedProperties.getAdditionalSensitivePropertiesKeysName();
    }

    @Override
    public List<String> getSensitivePropertyKeys() {
        String additionalPropertiesString = this.getAdditionalSensitivePropertiesKeys();
        String additionalPropertiesKeyName = this.protectedProperties.getAdditionalSensitivePropertiesKeysName();
        if (additionalPropertiesString == null || additionalPropertiesString.trim().isEmpty()) {
            return this.protectedProperties.getDefaultSensitiveProperties();
        }
        List<String> additionalProperties = ApplicationPropertiesProtector.splitMultipleProperties(additionalPropertiesString);
        if (additionalProperties.contains(additionalPropertiesKeyName)) {
            logger.warn("The key '{}' contains itself. This is poor practice and should be removed", (Object)additionalPropertiesKeyName);
            additionalProperties.remove(additionalPropertiesKeyName);
        }
        additionalProperties.addAll(this.protectedProperties.getDefaultSensitiveProperties());
        return additionalProperties;
    }

    @Override
    public List<String> getPopulatedSensitivePropertyKeys() {
        List<String> allSensitiveKeys = this.getSensitivePropertyKeys();
        return allSensitiveKeys.stream().filter(k -> StringUtils.isNotBlank((CharSequence)this.getProperty((String)k))).collect(Collectors.toList());
    }

    @Override
    public boolean hasProtectedKeys() {
        List<String> sensitiveKeys = this.getSensitivePropertyKeys();
        for (String k : sensitiveKeys) {
            if (!this.isPropertyProtected(k)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> getProtectedPropertyKeys() {
        List<String> sensitiveKeys = this.getSensitivePropertyKeys();
        HashMap<String, String> traditionalProtectedProperties = new HashMap<String, String>();
        for (String key : sensitiveKeys) {
            String protection = this.getProperty(ApplicationPropertiesProtector.getProtectionKey(key));
            if (!StringUtils.isNotBlank((CharSequence)protection) || !StringUtils.isNotBlank((CharSequence)this.getProperty(key))) continue;
            traditionalProtectedProperties.put(key, protection);
        }
        return traditionalProtectedProperties;
    }

    @Override
    public Set<String> getProtectionSchemes() {
        return new HashSet<String>(this.getProtectedPropertyKeys().values());
    }

    @Override
    public boolean isPropertySensitive(String key) {
        return key != null && !key.equals(this.getAdditionalSensitivePropertiesKeysName()) && this.getSensitivePropertyKeys().contains(key.trim());
    }

    @Override
    public boolean isPropertyProtected(String key) {
        return key != null && this.isPropertySensitive(key) && !StringUtils.isBlank((CharSequence)this.getProperty(ApplicationPropertiesProtector.getProtectionKey(key)));
    }

    @Override
    public U getUnprotectedProperties() throws SensitivePropertyProtectionException {
        if (this.hasProtectedKeys()) {
            logger.debug("Protected Properties [{}] Sensitive Properties [{}]", (Object)this.getProtectedPropertyKeys().size(), (Object)this.getSensitivePropertyKeys().size());
            Properties rawProperties = new Properties();
            HashSet<String> failedKeys = new HashSet<String>();
            for (String key : this.getPropertyKeys()) {
                if (key.endsWith(PROTECTED_KEY_SUFFIX)) continue;
                if (this.isPropertyProtected(key)) {
                    try {
                        rawProperties.setProperty(key, this.unprotectValue(key, this.getProperty(key)));
                    }
                    catch (SensitivePropertyProtectionException e) {
                        logger.warn("Failed to unprotect '{}'", (Object)key, (Object)e);
                        failedKeys.add(key);
                    }
                    continue;
                }
                rawProperties.setProperty(key, this.getProperty(key));
            }
            if (!failedKeys.isEmpty()) {
                if (failedKeys.size() > 1) {
                    logger.warn("Combining {} failed keys [{}] into single exception", (Object)failedKeys.size(), (Object)StringUtils.join(failedKeys, (String)", "));
                    throw new MultipleSensitivePropertyProtectionException("Failed to unprotect keys", failedKeys);
                }
                throw new SensitivePropertyProtectionException("Failed to unprotect key " + (String)failedKeys.iterator().next());
            }
            ApplicationProperties unprotected = this.protectedProperties.createApplicationProperties(rawProperties);
            return (U)unprotected;
        }
        logger.debug("No protected properties");
        return (U)this.protectedProperties.getApplicationProperties();
    }

    @Override
    public void addSensitivePropertyProvider(SensitivePropertyProvider sensitivePropertyProvider) {
        Objects.requireNonNull(sensitivePropertyProvider, "Cannot add null SensitivePropertyProvider");
        if (sensitivePropertyProvider == null) {
            throw new IllegalArgumentException("Cannot add null SensitivePropertyProvider");
        }
        if (this.getSensitivePropertyProviders().containsKey(sensitivePropertyProvider.getIdentifierKey())) {
            throw new UnsupportedOperationException("Cannot overwrite existing sensitive property provider registered for " + sensitivePropertyProvider.getIdentifierKey());
        }
        this.getSensitivePropertyProviders().put(sensitivePropertyProvider.getIdentifierKey(), sensitivePropertyProvider);
    }

    public String toString() {
        Set<String> providers = this.getSensitivePropertyProviders().keySet();
        return "ApplicationPropertiesProtector instance with " + this.size() + " properties (" + this.getProtectedPropertyKeys().size() + " protected) and " + providers.size() + " sensitive property providers: " + StringUtils.join(providers, (String)", ");
    }

    @Override
    public Map<String, SensitivePropertyProvider> getSensitivePropertyProviders() {
        if (this.localProviderCache == null) {
            this.localProviderCache = new HashMap<String, SensitivePropertyProvider>();
        }
        return this.localProviderCache;
    }

    private SensitivePropertyProvider getSensitivePropertyProvider(String protectionScheme) {
        if (this.isProviderAvailable(protectionScheme)) {
            return this.getSensitivePropertyProviders().get(protectionScheme);
        }
        throw new SensitivePropertyProtectionException("No provider available for " + protectionScheme);
    }

    private boolean isProviderAvailable(String protectionScheme) {
        return this.getSensitivePropertyProviders().containsKey(protectionScheme);
    }

    private String unprotectValue(String key, String retrievedValue) {
        if (this.isPropertyProtected(key)) {
            String protectionScheme = this.getProperty(ApplicationPropertiesProtector.getProtectionKey(key));
            if (!this.isProviderAvailable(protectionScheme)) {
                throw new IllegalStateException(String.format("No provider available for " + key, new Object[0]));
            }
            try {
                SensitivePropertyProvider sensitivePropertyProvider = this.getSensitivePropertyProvider(protectionScheme);
                return sensitivePropertyProvider.unprotect(retrievedValue);
            }
            catch (SensitivePropertyProtectionException e) {
                logger.error("Error unprotecting value for " + key, (Throwable)e);
                throw e;
            }
            catch (IllegalArgumentException e) {
                throw new SensitivePropertyProtectionException("Error unprotecting value for " + key, e);
            }
        }
        return retrievedValue;
    }
}

