/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.properties.AbstractHashiCorpVaultSensitivePropertyProvider;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.PropertyProtectionScheme;
import org.apache.nifi.properties.SensitivePropertyProtectionException;

public class HashiCorpVaultTransitSensitivePropertyProvider
extends AbstractHashiCorpVaultSensitivePropertyProvider {
    private static final Charset PROPERTY_CHARSET = StandardCharsets.UTF_8;
    private static final String TRANSIT_PATH = "vault.transit.path";

    HashiCorpVaultTransitSensitivePropertyProvider(BootstrapProperties bootstrapProperties) {
        super(bootstrapProperties);
    }

    @Override
    protected String getSecretsEnginePath(BootstrapProperties vaultBootstrapProperties) {
        if (vaultBootstrapProperties == null) {
            return null;
        }
        String transitPath = vaultBootstrapProperties.getProperty(TRANSIT_PATH);
        try {
            PropertyProtectionScheme.fromIdentifier(this.getProtectionScheme().getIdentifier(transitPath));
        }
        catch (IllegalArgumentException e) {
            throw new SensitivePropertyProtectionException(String.format("%s [%s] contains unsupported characters", TRANSIT_PATH, transitPath), e);
        }
        return transitPath;
    }

    @Override
    protected PropertyProtectionScheme getProtectionScheme() {
        return PropertyProtectionScheme.HASHICORP_VAULT_TRANSIT;
    }

    @Override
    protected boolean hasRequiredSecretsEngineProperties(BootstrapProperties vaultBootstrapProperties) {
        return this.getSecretsEnginePath(vaultBootstrapProperties) != null;
    }

    @Override
    public String protect(String unprotectedValue) throws SensitivePropertyProtectionException {
        if (StringUtils.isBlank((CharSequence)unprotectedValue)) {
            throw new IllegalArgumentException("Cannot encrypt an empty value");
        }
        return this.getVaultCommunicationService().encrypt(this.getPath(), unprotectedValue.getBytes(PROPERTY_CHARSET));
    }

    @Override
    public String unprotect(String protectedValue) throws SensitivePropertyProtectionException {
        if (StringUtils.isBlank((CharSequence)protectedValue)) {
            throw new IllegalArgumentException("Cannot decrypt an empty value");
        }
        return new String(this.getVaultCommunicationService().decrypt(this.getPath(), protectedValue), PROPERTY_CHARSET);
    }
}

