/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.util.Arrays;
import java.util.Objects;

public enum PropertyProtectionScheme {
    AES_GCM("aes/gcm/(128|192|256)", "aes/gcm/%s", "AES Sensitive Property Provider", true),
    HASHICORP_VAULT_TRANSIT("hashicorp/vault/transit/[a-zA-Z0-9_-]+", "hashicorp/vault/transit/%s", "HashiCorp Vault Transit Engine Sensitive Property Provider", false);

    private final String identifierFormat;
    private final String identifierPattern;
    private final String name;
    private final boolean requiresSecretKey;

    private PropertyProtectionScheme(String identifierPattern, String identifierFormat, String name, boolean requiresSecretKey) {
        this.identifierPattern = identifierPattern;
        this.identifierFormat = identifierFormat;
        this.name = name;
        this.requiresSecretKey = requiresSecretKey;
    }

    public String getIdentifier(String ... args) {
        return String.format(this.identifierFormat, args);
    }

    public boolean requiresSecretKey() {
        return this.requiresSecretKey;
    }

    public String getName() {
        return this.name;
    }

    public static PropertyProtectionScheme fromIdentifier(String identifier) {
        Objects.requireNonNull(identifier, "Identifier must be specified");
        return Arrays.stream(PropertyProtectionScheme.values()).filter(scheme -> identifier.matches(scheme.identifierPattern)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unrecognized protection scheme :" + identifier));
    }
}

