/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.nifi.properties.AESSensitivePropertyProvider;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.HashiCorpVaultTransitSensitivePropertyProvider;
import org.apache.nifi.properties.PropertyProtectionScheme;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.util.NiFiBootstrapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSensitivePropertyProviderFactory
implements SensitivePropertyProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(StandardSensitivePropertyProviderFactory.class);
    private final Optional<String> keyHex;
    private final Supplier<BootstrapProperties> bootstrapPropertiesSupplier;
    private final Map<PropertyProtectionScheme, SensitivePropertyProvider> providerMap;

    public static SensitivePropertyProviderFactory withDefaults() {
        return StandardSensitivePropertyProviderFactory.withKeyAndBootstrapSupplier(null, null);
    }

    public static SensitivePropertyProviderFactory withKey(String keyHex) {
        return new StandardSensitivePropertyProviderFactory(keyHex, null);
    }

    public static SensitivePropertyProviderFactory withKeyAndBootstrapSupplier(String keyHex, Supplier<BootstrapProperties> bootstrapPropertiesSupplier) {
        return new StandardSensitivePropertyProviderFactory(keyHex, bootstrapPropertiesSupplier);
    }

    private StandardSensitivePropertyProviderFactory(String keyHex, Supplier<BootstrapProperties> bootstrapPropertiesSupplier) {
        this.keyHex = Optional.ofNullable(keyHex);
        this.bootstrapPropertiesSupplier = bootstrapPropertiesSupplier == null ? () -> null : bootstrapPropertiesSupplier;
        this.providerMap = new HashMap<PropertyProtectionScheme, SensitivePropertyProvider>();
    }

    private String getKeyHex() {
        return this.keyHex.orElseGet(() -> (String)this.getBootstrapProperties().getProperty(BootstrapProperties.BootstrapPropertyKey.SENSITIVE_KEY).orElseThrow(() -> new SensitivePropertyProtectionException("Could not read root key from bootstrap.conf")));
    }

    private BootstrapProperties getBootstrapProperties() {
        return Optional.ofNullable(this.bootstrapPropertiesSupplier.get()).orElseGet(() -> {
            try {
                return NiFiBootstrapUtils.loadBootstrapProperties();
            }
            catch (IOException e) {
                logger.debug("Could not load bootstrap.conf from disk, so using empty bootstrap.conf", (Throwable)e);
                return BootstrapProperties.EMPTY;
            }
        });
    }

    @Override
    public SensitivePropertyProvider getProvider(PropertyProtectionScheme protectionScheme) throws SensitivePropertyProtectionException {
        Objects.requireNonNull(protectionScheme, "Protection scheme is required");
        String keyHex = protectionScheme.requiresSecretKey() ? this.getKeyHex() : null;
        switch (protectionScheme) {
            case AES_GCM: {
                return this.providerMap.computeIfAbsent(protectionScheme, s -> new AESSensitivePropertyProvider(keyHex));
            }
            case HASHICORP_VAULT_TRANSIT: {
                return this.providerMap.computeIfAbsent(protectionScheme, s -> new HashiCorpVaultTransitSensitivePropertyProvider(this.getBootstrapProperties()));
            }
        }
        throw new SensitivePropertyProtectionException("Unsupported protection scheme " + (Object)((Object)protectionScheme));
    }

    @Override
    public Collection<SensitivePropertyProvider> getSupportedSensitivePropertyProviders() {
        return Arrays.stream(PropertyProtectionScheme.values()).map(this::getProvider).filter(SensitivePropertyProvider::isSupported).collect(Collectors.toList());
    }
}

