/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.vault.hashicorp;

import org.apache.nifi.vault.hashicorp.HashiCorpVaultCommunicationService;
import org.apache.nifi.vault.hashicorp.HashiCorpVaultConfigurationException;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultConfiguration;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultProperties;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.SimpleSessionManager;
import org.springframework.vault.client.ClientHttpRequestFactoryFactory;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.core.VaultTransitOperations;
import org.springframework.vault.support.Ciphertext;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.Plaintext;
import org.springframework.vault.support.SslConfiguration;

public class StandardHashiCorpVaultCommunicationService
implements HashiCorpVaultCommunicationService {
    private final HashiCorpVaultConfiguration vaultConfiguration;
    private final VaultTemplate vaultTemplate;
    private final VaultTransitOperations transitOperations;

    public StandardHashiCorpVaultCommunicationService(PropertySource<?> ... propertySources) throws HashiCorpVaultConfigurationException {
        this.vaultConfiguration = new HashiCorpVaultConfiguration(propertySources);
        this.vaultTemplate = new VaultTemplate(this.vaultConfiguration.vaultEndpoint(), ClientHttpRequestFactoryFactory.create((ClientOptions)this.vaultConfiguration.clientOptions(), (SslConfiguration)this.vaultConfiguration.sslConfiguration()), (SessionManager)new SimpleSessionManager(this.vaultConfiguration.clientAuthentication()));
        this.transitOperations = this.vaultTemplate.opsForTransit();
    }

    public StandardHashiCorpVaultCommunicationService(HashiCorpVaultProperties vaultProperties) throws HashiCorpVaultConfigurationException {
        this(new HashiCorpVaultPropertySource(vaultProperties));
    }

    @Override
    public String encrypt(String transitKey, byte[] plainText) {
        return this.transitOperations.encrypt(transitKey, Plaintext.of((byte[])plainText)).getCiphertext();
    }

    @Override
    public byte[] decrypt(String transitKey, String cipherText) {
        return this.transitOperations.decrypt(transitKey, Ciphertext.of((String)cipherText)).getPlaintext();
    }
}

