/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.vault.hashicorp.config;

import java.io.File;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.vault.hashicorp.HashiCorpVaultConfigurationException;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultProperty;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultSslProperties;

public class HashiCorpVaultProperties {
    public static final String HTTPS = "https";
    private final String uri;
    private final String authPropertiesFilename;
    private final HashiCorpVaultSslProperties ssl;
    private final Optional<String> connectionTimeout;
    private final Optional<String> readTimeout;

    private HashiCorpVaultProperties(String uri, String keyStore, String keyStoreType, String keyStorePassword, String trustStore, String trustStoreType, String trustStorePassword, String authPropertiesFilename, String enabledTlsCipherSuites, String enabledTlsProtocols, String connectionTimeout, String readTimeout) {
        Objects.requireNonNull(uri, "Vault URI is required");
        Objects.requireNonNull(authPropertiesFilename, "Vault auth properties filename is required");
        this.uri = uri;
        this.authPropertiesFilename = authPropertiesFilename;
        this.ssl = new HashiCorpVaultSslProperties(keyStore, keyStoreType, keyStorePassword, trustStore, trustStoreType, trustStorePassword, enabledTlsCipherSuites, enabledTlsProtocols);
        this.connectionTimeout = connectionTimeout == null ? Optional.empty() : Optional.of(connectionTimeout);
        Optional<Object> optional = this.readTimeout = readTimeout == null ? Optional.empty() : Optional.of(readTimeout);
        if (uri.startsWith(HTTPS)) {
            Objects.requireNonNull(keyStore, "KeyStore is required with an https URI");
            Objects.requireNonNull(keyStorePassword, "KeyStore password is required with an https URI");
            Objects.requireNonNull(keyStoreType, "KeyStore type is required with an https URI");
            Objects.requireNonNull(trustStore, "TrustStore is required with an https URI");
            Objects.requireNonNull(trustStorePassword, "TrustStore password is required with an https URI");
            Objects.requireNonNull(trustStoreType, "TrustStore type is required with an https URI");
        }
        this.validateAuthProperties();
    }

    private void validateAuthProperties() throws HashiCorpVaultConfigurationException {
        File authPropertiesFile = Paths.get(this.authPropertiesFilename, new String[0]).toFile();
        if (!authPropertiesFile.exists()) {
            throw new HashiCorpVaultConfigurationException(String.format("Auth properties file [%s] does not exist", this.authPropertiesFilename));
        }
    }

    @HashiCorpVaultProperty
    public String getUri() {
        return this.uri;
    }

    @HashiCorpVaultProperty
    public HashiCorpVaultSslProperties getSsl() {
        return this.ssl;
    }

    @HashiCorpVaultProperty(key="authentication.properties.file")
    public String getAuthPropertiesFilename() {
        return this.authPropertiesFilename;
    }

    public Optional<String> getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Optional<String> getReadTimeout() {
        return this.readTimeout;
    }

    public static class HashiCorpVaultPropertiesBuilder {
        private String uri;
        private String keyStore;
        private String keyStoreType;
        private String keyStorePassword;
        private String trustStore;
        private String trustStoreType;
        private String trustStorePassword;
        private String authPropertiesFilename;
        private String enabledTlsCipherSuites;
        private String enabledTlsProtocols;
        private String connectionTimeout;
        private String readTimeout;

        public HashiCorpVaultPropertiesBuilder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public HashiCorpVaultPropertiesBuilder setKeyStore(String keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public HashiCorpVaultPropertiesBuilder setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public HashiCorpVaultPropertiesBuilder setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public HashiCorpVaultPropertiesBuilder setTrustStore(String trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        public HashiCorpVaultPropertiesBuilder setTrustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public HashiCorpVaultPropertiesBuilder setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public HashiCorpVaultPropertiesBuilder setAuthPropertiesFilename(String authPropertiesFilename) {
            this.authPropertiesFilename = authPropertiesFilename;
            return this;
        }

        public HashiCorpVaultPropertiesBuilder setEnabledTlsCipherSuites(String enabledTlsCipherSuites) {
            this.enabledTlsCipherSuites = enabledTlsCipherSuites;
            return this;
        }

        public HashiCorpVaultPropertiesBuilder setEnabledTlsProtocols(String enabledTlsProtocols) {
            this.enabledTlsProtocols = enabledTlsProtocols;
            return this;
        }

        public HashiCorpVaultPropertiesBuilder setConnectionTimeout(String connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public HashiCorpVaultPropertiesBuilder setReadTimeout(String readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public HashiCorpVaultProperties build() {
            return new HashiCorpVaultProperties(this.uri, this.keyStore, this.keyStoreType, this.keyStorePassword, this.trustStore, this.trustStoreType, this.trustStorePassword, this.authPropertiesFilename, this.enabledTlsCipherSuites, this.enabledTlsProtocols, this.connectionTimeout, this.readTimeout);
        }
    }
}

