/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.api.ConnectionFailureException;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherURIHandler;
import org.apache.oozie.util.HCatURI;

public class HCatLauncherURIHandler
implements LauncherURIHandler {
    private static List<Class<?>> classesToShip = new ArrayList();

    public boolean create(URI uri, Configuration conf) throws LauncherException {
        throw new UnsupportedOperationException("Creation of partition is not supported for " + uri);
    }

    public boolean delete(URI uri, Configuration conf) throws LauncherException {
        HCatClient client = this.getHCatClient(uri, conf);
        try {
            HCatURI hcatURI = new HCatURI(uri.toString());
            if (!hcatURI.getPartitionMap().isEmpty()) {
                client.dropPartitions(hcatURI.getDb(), hcatURI.getTable(), hcatURI.getPartitionMap(), true);
            } else {
                client.dropTable(hcatURI.getDb(), hcatURI.getTable(), true);
            }
            System.out.println("Dropped partitions for " + uri);
            boolean bl = true;
            return bl;
        }
        catch (ConnectionFailureException e) {
            throw new LauncherException("Error trying to drop " + uri, (Throwable)e);
        }
        catch (HCatException e) {
            throw new LauncherException("Error trying to drop " + uri, (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new LauncherException("Error trying to drop " + uri, (Throwable)e);
        }
        finally {
            this.closeQuietly(client);
        }
    }

    private HCatClient getHCatClient(URI uri, Configuration conf) throws LauncherException {
        HiveConf hiveConf = new HiveConf();
        for (Map.Entry entry : conf) {
            hiveConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        String serverURI = this.getMetastoreConnectURI(uri);
        if (!serverURI.equals("")) {
            hiveConf.set("hive.metastore.local", "false");
        }
        hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, serverURI);
        try {
            System.out.println("Creating HCatClient for user=" + UserGroupInformation.getCurrentUser() + " and server=" + serverURI);
            return HCatClient.create((Configuration)hiveConf);
        }
        catch (HCatException e) {
            throw new LauncherException("Error trying to connect to " + serverURI, (Throwable)e);
        }
        catch (IOException e) {
            throw new LauncherException("Error trying to connect to " + serverURI, (Throwable)e);
        }
    }

    private String getMetastoreConnectURI(URI uri) {
        String metastoreURI = uri.getAuthority().equals("unittest-local") ? "" : "thrift://" + uri.getAuthority();
        return metastoreURI;
    }

    private void closeQuietly(HCatClient client) {
        if (client != null) {
            try {
                client.close();
            }
            catch (Exception ignore) {
                System.err.println("Error closing hcat client");
                ignore.printStackTrace(System.err);
            }
        }
    }

    public List<Class<?>> getClassesForLauncher() {
        return classesToShip;
    }

    static {
        classesToShip.add(HCatURI.class);
    }
}

