/*
 * Decompiled with CFR 0.152.
 */
package serp.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedList;
import serp.util.Numbers;

public class Strings {
    private static final Object[][] _codes = new Object[][]{{Byte.TYPE, "byte", "B"}, {Character.TYPE, "char", "C"}, {Double.TYPE, "double", "D"}, {Float.TYPE, "float", "F"}, {Integer.TYPE, "int", "I"}, {Long.TYPE, "long", "J"}, {Short.TYPE, "short", "S"}, {Boolean.TYPE, "boolean", "Z"}, {Void.TYPE, "void", "V"}};

    public static String replace(String str, String from, String to) {
        Object[] split = Strings.split(str, from, Integer.MAX_VALUE);
        return Strings.join(split, to);
    }

    public static String[] split(String str, String token, int max) {
        if (str == null || str.length() == 0) {
            return new String[0];
        }
        if (token == null || token.length() == 0) {
            throw new IllegalArgumentException("token: [" + token + "]");
        }
        LinkedList<String> ret = new LinkedList<String>();
        int start = 0;
        int split = 0;
        while (split != -1) {
            split = str.indexOf(token, start);
            if (split == -1 && start >= str.length()) {
                ret.add("");
                continue;
            }
            if (split == -1) {
                ret.add(str.substring(start));
                continue;
            }
            ret.add(str.substring(start, split));
            start = split + token.length();
        }
        if (max == 0) {
            while (ret.getLast().equals("")) {
                ret.removeLast();
            }
        } else if (max > 0 && ret.size() > max) {
            StringBuilder buf = new StringBuilder(ret.removeLast().toString());
            while (ret.size() >= max) {
                buf.insert(0, token);
                buf.insert(0, ret.removeLast());
            }
            ret.add(buf.toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static String join(Object[] strings, String token) {
        if (strings == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(20 * strings.length);
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                buf.append(token);
            }
            if (strings[i] == null) continue;
            buf.append(strings[i]);
        }
        return buf.toString();
    }

    public static Class toClass(String str, ClassLoader loader) {
        return Strings.toClass(str, false, loader);
    }

    public static Class toClass(String str, boolean resolve, ClassLoader loader) {
        if (str == null) {
            throw new NullPointerException("str == null");
        }
        int dims = 0;
        while (str.endsWith("[]")) {
            ++dims;
            str = str.substring(0, str.length() - 2);
        }
        boolean primitive = false;
        if (str.indexOf(46) == -1) {
            for (int i = 0; !primitive && i < _codes.length; ++i) {
                if (!_codes[i][1].equals(str)) continue;
                if (dims == 0) {
                    return (Class)_codes[i][0];
                }
                str = (String)_codes[i][2];
                primitive = true;
            }
        }
        if (dims > 0) {
            int size = str.length() + dims;
            if (!primitive) {
                size += 2;
            }
            StringBuilder buf = new StringBuilder(size);
            for (int i = 0; i < dims; ++i) {
                buf.append('[');
            }
            if (!primitive) {
                buf.append('L');
            }
            buf.append(str);
            if (!primitive) {
                buf.append(';');
            }
            str = buf.toString();
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        try {
            return Class.forName(str, resolve, loader);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t.toString());
        }
    }

    public static String getClassName(Class cls) {
        return cls == null ? null : Strings.getClassName(cls.getName());
    }

    public static String getClassName(String fullName) {
        int i;
        if (fullName == null) {
            return null;
        }
        int dims = 0;
        for (i = 0; i < fullName.length(); ++i) {
            if (fullName.charAt(i) == '[') continue;
            dims = i;
            break;
        }
        if (dims > 0) {
            fullName = fullName.substring(dims);
        }
        for (i = 0; i < _codes.length; ++i) {
            if (!_codes[i][2].equals(fullName)) continue;
            fullName = (String)_codes[i][1];
            break;
        }
        fullName = fullName.substring(fullName.lastIndexOf(46) + 1);
        for (i = 0; i < dims; ++i) {
            fullName = fullName + "[]";
        }
        return fullName;
    }

    public static String getPackageName(Class cls) {
        return cls == null ? null : Strings.getPackageName(cls.getName());
    }

    public static String getPackageName(String fullName) {
        if (fullName == null) {
            return null;
        }
        int dotIdx = fullName.lastIndexOf(46);
        return dotIdx == -1 ? "" : fullName.substring(0, dotIdx);
    }

    public static Object parse(String val, Class type) {
        if (!Strings.canParse(type)) {
            throw new IllegalArgumentException("invalid type: " + type.getName());
        }
        if (val == null) {
            if (!type.isPrimitive()) {
                return null;
            }
            if (type == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (type == Byte.TYPE) {
                return new Byte(0);
            }
            if (type == Character.TYPE) {
                return new Character('\u0000');
            }
            if (type == Double.TYPE) {
                return new Double(0.0);
            }
            if (type == Float.TYPE) {
                return new Float(0.0f);
            }
            if (type == Integer.TYPE) {
                return Numbers.valueOf(0);
            }
            if (type == Long.TYPE) {
                return Numbers.valueOf(0L);
            }
            if (type == Short.TYPE) {
                return new Short(0);
            }
            throw new IllegalStateException("invalid type: " + type);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.valueOf(val);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.valueOf(val);
        }
        if (type == Character.TYPE || type == Character.class) {
            if (val.length() == 0) {
                return new Character('\u0000');
            }
            if (val.length() == 1) {
                return new Character(val.charAt(0));
            }
            throw new IllegalArgumentException("'" + val + "' is longer than " + "one character.");
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.valueOf(val);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(val);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.valueOf(val);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.valueOf(val);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.valueOf(val);
        }
        if (type == String.class) {
            return val;
        }
        if (type == Date.class) {
            return new Date(val);
        }
        if (type == BigInteger.class) {
            return new BigInteger(val);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(val);
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    public static boolean canParse(Class type) {
        return type.isPrimitive() || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class || type == Date.class || type == BigInteger.class || type == BigDecimal.class;
    }
}

