/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.connectionpool;

import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.utils.connectionpool.PoolKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PooledPlcConnectionFactory
extends BaseKeyedPooledObjectFactory<PoolKey, PlcConnection> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledPlcConnectionFactory.class);

    public PooledObject<PlcConnection> wrap(PlcConnection plcConnection) {
        LOGGER.debug("Wrapping connection {}", (Object)plcConnection);
        return new DefaultPooledObject((Object)plcConnection);
    }

    public void destroyObject(PoolKey key, PooledObject<PlcConnection> p) throws Exception {
        ((PlcConnection)p.getObject()).close();
    }

    public boolean validateObject(PoolKey key, PooledObject<PlcConnection> p) {
        return ((PlcConnection)p.getObject()).isConnected();
    }
}

