/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.can.generic.protocol;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.can.adapter.Plc4xCANProtocolBase;
import org.apache.plc4x.java.can.generic.field.GenericCANField;
import org.apache.plc4x.java.can.generic.protocol.GenericCANSubscriptionHandle;
import org.apache.plc4x.java.can.generic.transport.GenericFrame;
import org.apache.plc4x.java.genericcan.readwrite.DataItem;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionField;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionHandle;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericCANProtocolLogic
extends Plc4xCANProtocolBase<GenericFrame>
implements PlcSubscriber {
    private final Logger logger = LoggerFactory.getLogger(GenericCANProtocolLogic.class);
    private RequestTransactionManager tm;
    private final Map<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> consumers = new ConcurrentHashMap<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>>();

    public void setDriverContext(DriverContext driverContext) {
        super.setDriverContext(driverContext);
        this.tm = new RequestTransactionManager(1);
    }

    public void setContext(ConversationContext<GenericFrame> context) {
        super.setContext(context);
    }

    public void onConnect(ConversationContext<GenericFrame> context) {
        context.fireConnected();
    }

    public void onDisconnect(ConversationContext<GenericFrame> context) {
        context.fireDisconnected();
    }

    public void close(ConversationContext<GenericFrame> context) {
    }

    @Override
    public void decode(ConversationContext<GenericFrame> context, GenericFrame msg) throws Exception {
        for (Map.Entry<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> entry : this.consumers.entrySet()) {
            DefaultPlcConsumerRegistration registration = entry.getKey();
            Consumer<PlcSubscriptionEvent> consumer = entry.getValue();
            for (PlcSubscriptionHandle handle : registration.getSubscriptionHandles()) {
                GenericCANSubscriptionHandle subscription = (GenericCANSubscriptionHandle)handle;
                LinkedHashMap<String, ResponseItem> fields = new LinkedHashMap<String, ResponseItem>();
                ReadBufferByteBased buffer = new ReadBufferByteBased(msg.getData(), ByteOrder.LITTLE_ENDIAN);
                buffer.pullContext("readFields", new WithReaderArgs[0]);
                if (subscription.matches(msg.getNodeId())) {
                    for (Map.Entry<String, GenericCANField> field : subscription.getFields().entrySet()) {
                        try {
                            PlcValue value = this.read((ReadBuffer)buffer, field.getValue());
                            if (value == null) {
                                fields.put(field.getKey(), new ResponseItem(PlcResponseCode.INTERNAL_ERROR, null));
                                continue;
                            }
                            fields.put(field.getKey(), new ResponseItem(PlcResponseCode.OK, (Object)value));
                        }
                        catch (ParseException e) {
                            fields.put(field.getKey(), new ResponseItem(PlcResponseCode.INVALID_DATA, null));
                        }
                    }
                    consumer.accept((PlcSubscriptionEvent)new DefaultPlcSubscriptionEvent(Instant.now(), fields));
                }
                buffer.closeContext("readFields", new WithReaderArgs[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlcValue read(ReadBuffer buffer, GenericCANField field) throws ParseException {
        try {
            buffer.pullContext("read-" + field, new WithReaderArgs[0]);
            PlcValue plcValue = DataItem.staticParse(buffer, field.getDataType());
            return plcValue;
        }
        finally {
            buffer.closeContext("read-" + field, new WithReaderArgs[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(WriteBuffer buffer, GenericCANField field, PlcValue value) throws SerializationException {
        WriteBufferByteBased writeBuffer = new WriteBufferByteBased(DataItem.getLengthInBytes(value, field.getDataType()));
        DataItem.staticSerialize((WriteBuffer)writeBuffer, value, field.getDataType());
        try {
            buffer.pushContext("write-" + field, new WithWriterArgs[0]);
            buffer.writeByteArray(writeBuffer.getData(), new WithWriterArgs[0]);
        }
        finally {
            buffer.popContext("write-" + field, new WithWriterArgs[0]);
        }
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        CompletableFuture<PlcWriteResponse> response = new CompletableFuture<PlcWriteResponse>();
        transaction.submit(() -> {
            LinkedHashMap<Integer, WriteBufferByteBased> messages = new LinkedHashMap<Integer, WriteBufferByteBased>();
            HashMap<Integer, Map> responses = new HashMap<Integer, Map>();
            for (String field : writeRequest.getFieldNames()) {
                PlcField plcField = writeRequest.getField(field);
                if (!(plcField instanceof GenericCANField)) {
                    responses.computeIfAbsent(-1, node -> new HashMap()).put(field, PlcResponseCode.UNSUPPORTED);
                    continue;
                }
                GenericCANField canField = (GenericCANField)plcField;
                WriteBuffer buffer = (WriteBuffer)messages.computeIfAbsent(canField.getNodeId(), node -> new WriteBufferByteBased(8, ByteOrder.LITTLE_ENDIAN));
                Map map = responses.computeIfAbsent(canField.getNodeId(), node -> new HashMap());
                PlcValue value = writeRequest.getPlcValue(field);
                try {
                    this.write(buffer, canField, value);
                    map.put(field, PlcResponseCode.OK);
                }
                catch (SerializationException e) {
                    map.put(field, PlcResponseCode.INVALID_DATA);
                }
            }
            HashMap<String, PlcResponseCode> codes = new HashMap<String, PlcResponseCode>();
            for (Map.Entry message : messages.entrySet()) {
                boolean discarded = false;
                for (Map.Entry entry : ((Map)responses.get(message.getKey())).entrySet()) {
                    codes.put((String)entry.getKey(), (PlcResponseCode)entry.getValue());
                    if (discarded || entry.getValue() == PlcResponseCode.OK) continue;
                    this.logger.info("Discarding writing of frame with field {}. Node {} will not be communicated.", entry.getKey(), message.getKey());
                    discarded = true;
                }
                if (discarded) continue;
                byte[] data = ((WriteBufferByteBased)message.getValue()).getData();
                this.logger.debug("Writing message with id {} and {} bytes of data", message.getKey(), (Object)data.length);
                this.context.sendToWire((Object)new GenericFrame((Integer)message.getKey(), data));
            }
            response.complete((PlcWriteResponse)new DefaultPlcWriteResponse(writeRequest, codes));
            transaction.endRequest();
        });
        return response;
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest request) {
        DefaultPlcSubscriptionRequest rq = (DefaultPlcSubscriptionRequest)request;
        LinkedHashMap<String, ResponseItem> answers = new LinkedHashMap<String, ResponseItem>();
        DefaultPlcSubscriptionResponse response = new DefaultPlcSubscriptionResponse((PlcSubscriptionRequest)rq, answers);
        HashMap<Integer, GenericCANSubscriptionHandle> handles = new HashMap<Integer, GenericCANSubscriptionHandle>();
        for (String key : rq.getFieldNames()) {
            DefaultPlcSubscriptionField subscription = (DefaultPlcSubscriptionField)rq.getField(key);
            if (subscription.getPlcSubscriptionType() != PlcSubscriptionType.EVENT) {
                answers.put(key, new ResponseItem(PlcResponseCode.UNSUPPORTED, null));
                continue;
            }
            if (subscription.getPlcField() instanceof GenericCANField) {
                GenericCANField canField = (GenericCANField)subscription.getPlcField();
                GenericCANSubscriptionHandle subscriptionHandle = handles.computeIfAbsent(canField.getNodeId(), node -> new GenericCANSubscriptionHandle(this, (Integer)node));
                answers.put(key, new ResponseItem(PlcResponseCode.OK, (Object)subscriptionHandle));
                subscriptionHandle.add(key, canField);
                continue;
            }
            answers.put(key, new ResponseItem(PlcResponseCode.INVALID_ADDRESS, null));
        }
        return CompletableFuture.completedFuture(response);
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        DefaultPlcConsumerRegistration consumerRegistration = new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, (PlcSubscriptionHandle[])handles.toArray(new DefaultPlcSubscriptionHandle[0]));
        this.consumers.put(consumerRegistration, consumer);
        return consumerRegistration;
    }

    public void unregister(PlcConsumerRegistration registration) {
        this.consumers.remove(registration);
    }
}

