/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.can.generic.protocol;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.plc4x.java.can.generic.field.GenericCANField;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionHandle;

public class GenericCANSubscriptionHandle
extends DefaultPlcSubscriptionHandle {
    private final Map<String, GenericCANField> fields = new LinkedHashMap<String, GenericCANField>();
    private final Integer nodeId;

    public GenericCANSubscriptionHandle(PlcSubscriber subscriber, Integer nodeId) {
        super(subscriber);
        this.nodeId = nodeId;
    }

    public boolean matches(int identifier) {
        return this.nodeId == identifier;
    }

    public String toString() {
        return "GenericCANSubscriptionHandle [node=" + this.nodeId + " " + GenericCANSubscriptionHandle.intAndHex(this.nodeId) + "]";
    }

    public void add(String name, GenericCANField field) {
        this.fields.put(name, field);
    }

    private static String intAndHex(int val) {
        return val + "(0x" + Integer.toHexString(val) + ")";
    }

    public Map<String, GenericCANField> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }
}

