/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.genericcan.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum GenericCANDataType {
    BYTE(0L, 8),
    BOOLEAN(1L, 1),
    UNSIGNED8(2L, 8),
    UNSIGNED16(3L, 16),
    UNSIGNED24(4L, 24),
    UNSIGNED32(5L, 32),
    UNSIGNED40(6L, 40),
    UNSIGNED48(7L, 48),
    UNSIGNED56(8L, 56),
    UNSIGNED64(9L, 64),
    INTEGER8(10L, 8),
    INTEGER16(11L, 16),
    INTEGER24(12L, 24),
    INTEGER32(13L, 32),
    INTEGER40(14L, 40),
    INTEGER48(15L, 48),
    INTEGER56(16L, 56),
    INTEGER64(17L, 64),
    REAL32(18L, 32),
    REAL64(19L, 64);

    private static final Map<Long, GenericCANDataType> map;
    private long value;
    private short numBits;

    private GenericCANDataType(long value, short numBits) {
        this.value = value;
        this.numBits = numBits;
    }

    public long getValue() {
        return this.value;
    }

    public short getNumBits() {
        return this.numBits;
    }

    public static GenericCANDataType firstEnumForFieldNumBits(short fieldValue) {
        for (GenericCANDataType _val : GenericCANDataType.values()) {
            if (_val.getNumBits() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<GenericCANDataType> enumsForFieldNumBits(short fieldValue) {
        ArrayList<GenericCANDataType> _values = new ArrayList<GenericCANDataType>();
        for (GenericCANDataType _val : GenericCANDataType.values()) {
            if (_val.getNumBits() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static GenericCANDataType enumForValue(long value) {
        return map.get(value);
    }

    public static Boolean isDefined(long value) {
        return map.containsKey(value);
    }

    static {
        map = new HashMap<Long, GenericCANDataType>();
        for (GenericCANDataType value : GenericCANDataType.values()) {
            map.put(value.getValue(), value);
        }
    }
}

