/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.protocol;

import org.apache.plc4x.java.canopen.field.CANOpenSubscriptionField;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionHandle;

public class CANOpenSubscriptionHandle
extends DefaultPlcSubscriptionHandle {
    private final String name;
    private final CANOpenSubscriptionField field;

    public CANOpenSubscriptionHandle(PlcSubscriber subscriber, String name, CANOpenSubscriptionField field) {
        super(subscriber);
        this.name = name;
        this.field = field;
    }

    public boolean matches(CANOpenService service, int identifier) {
        if (this.field.getService() != service) {
            return false;
        }
        return this.field.isWildcard() || this.field.getNodeId() == identifier;
    }

    public String getName() {
        return this.name;
    }

    public CANOpenSubscriptionField getField() {
        return this.field;
    }

    public String toString() {
        return "CANopenSubscriptionHandle [service=" + (Object)((Object)this.field.getService()) + ", node=" + CANOpenSubscriptionHandle.intAndHex(this.field.getNodeId()) + ", cob=" + CANOpenSubscriptionHandle.intAndHex(this.field.getService().getMin() + this.field.getNodeId()) + "]";
    }

    private static String intAndHex(int val) {
        return val + "(0x" + Integer.toHexString(val) + ")";
    }
}

