/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.canopen.readwrite.SDORequest;
import org.apache.plc4x.java.canopen.readwrite.SDORequestCommand;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class SDOSegmentDownloadRequest
extends SDORequest
implements Message {
    protected final boolean toggle;
    protected final boolean last;
    protected final byte[] data;

    @Override
    public SDORequestCommand getCommand() {
        return SDORequestCommand.SEGMENT_DOWNLOAD;
    }

    public SDOSegmentDownloadRequest(boolean toggle, boolean last, byte[] data) {
        this.toggle = toggle;
        this.last = last;
        this.data = data;
    }

    public boolean getToggle() {
        return this.toggle;
    }

    public boolean getLast() {
        return this.last;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeSDORequestChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("SDOSegmentDownloadRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"toggle", (Object)this.toggle, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        byte size = (byte)(7 - StaticHelper.COUNT((Object)this.getData()));
        FieldWriterFactory.writeImplicitField((String)"size", (Object)size, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)3), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"last", (Object)this.last, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"data", (byte[])this.data, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writePaddingField((String)"padding", (int)(7 - StaticHelper.COUNT((Object)this.data)), (Object)0, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("SDOSegmentDownloadRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        SDOSegmentDownloadRequest _value = this;
        ++lengthInBits;
        lengthInBits += 3;
        ++lengthInBits;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        int _timesPadding = 7 - StaticHelper.COUNT((Object)this.data);
        while (_timesPadding-- > 0) {
            lengthInBits += 8;
        }
        return lengthInBits;
    }

    public static SDOSegmentDownloadRequestBuilder staticParseBuilder(ReadBuffer readBuffer, SDORequestCommand command) throws ParseException {
        readBuffer.pullContext("SDOSegmentDownloadRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        boolean toggle = (Boolean)FieldReaderFactory.readSimpleField((String)"toggle", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        byte size = (Byte)FieldReaderFactory.readImplicitField((String)"size", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)3), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean last = (Boolean)FieldReaderFactory.readSimpleField((String)"last", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(7 - size), new WithReaderArgs[0]);
        FieldReaderFactory.readPaddingField((DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (int)(7 - StaticHelper.COUNT((Object)data)), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("SDOSegmentDownloadRequest", new WithReaderArgs[0]);
        return new SDOSegmentDownloadRequestBuilder(toggle, last, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SDOSegmentDownloadRequest)) {
            return false;
        }
        SDOSegmentDownloadRequest that = (SDOSegmentDownloadRequest)o;
        return this.getToggle() == that.getToggle() && this.getLast() == that.getLast() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getToggle(), this.getLast(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class SDOSegmentDownloadRequestBuilder
    implements SDORequest.SDORequestBuilder {
        private final boolean toggle;
        private final boolean last;
        private final byte[] data;

        public SDOSegmentDownloadRequestBuilder(boolean toggle, boolean last, byte[] data) {
            this.toggle = toggle;
            this.last = last;
            this.data = data;
        }

        @Override
        public SDOSegmentDownloadRequest build() {
            SDOSegmentDownloadRequest sDOSegmentDownloadRequest = new SDOSegmentDownloadRequest(this.toggle, this.last, this.data);
            return sDOSegmentDownloadRequest;
        }
    }
}

