/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessage;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class FirmataMessageAnalogIO
extends FirmataMessage
implements Message {
    protected final byte pin;
    protected final List<Byte> data;
    protected final Boolean response;

    @Override
    public Byte getMessageType() {
        return (byte)14;
    }

    public FirmataMessageAnalogIO(byte pin, List<Byte> data, Boolean response) {
        super(response);
        this.pin = pin;
        this.data = data;
        this.response = response;
    }

    public byte getPin() {
        return this.pin;
    }

    public List<Byte> getData() {
        return this.data;
    }

    @Override
    protected void serializeFirmataMessageChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("FirmataMessageAnalogIO", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"pin", (Object)this.pin, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleTypeArrayField((String)"data", this.data, (DataWriter)DataWriterFactory.writeSignedByte((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("FirmataMessageAnalogIO", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        FirmataMessageAnalogIO _value = this;
        lengthInBits += 4;
        if (this.data != null) {
            lengthInBits += 8 * this.data.size();
        }
        return lengthInBits;
    }

    public static FirmataMessageAnalogIOBuilder staticParseBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("FirmataMessageAnalogIO", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        byte pin = (Byte)FieldReaderFactory.readSimpleField((String)"pin", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        List data = FieldReaderFactory.readCountArrayField((String)"data", (DataReader)DataReaderFactory.readSignedByte((ReadBuffer)readBuffer, (int)8), (long)2L, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("FirmataMessageAnalogIO", new WithReaderArgs[0]);
        return new FirmataMessageAnalogIOBuilder(pin, data, response);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FirmataMessageAnalogIO)) {
            return false;
        }
        FirmataMessageAnalogIO that = (FirmataMessageAnalogIO)o;
        return this.getPin() == that.getPin() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPin(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class FirmataMessageAnalogIOBuilder
    implements FirmataMessage.FirmataMessageBuilder {
        private final byte pin;
        private final List<Byte> data;
        private final Boolean response;

        public FirmataMessageAnalogIOBuilder(byte pin, List<Byte> data, Boolean response) {
            this.pin = pin;
            this.data = data;
            this.response = response;
        }

        @Override
        public FirmataMessageAnalogIO build(Boolean response) {
            FirmataMessageAnalogIO firmataMessageAnalogIO = new FirmataMessageAnalogIO(this.pin, this.data, response);
            return firmataMessageAnalogIO;
        }
    }
}

