/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite.context;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.model.PlcSubscriptionField;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.firmata.readwrite.FirmataCommandSetDigitalPinValue;
import org.apache.plc4x.java.firmata.readwrite.FirmataCommandSetPinMode;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessage;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageCommand;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageSubscribeAnalogPinValue;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageSubscribeDigitalPinValue;
import org.apache.plc4x.java.firmata.readwrite.PinMode;
import org.apache.plc4x.java.firmata.readwrite.field.FirmataFieldAnalog;
import org.apache.plc4x.java.firmata.readwrite.field.FirmataFieldDigital;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionField;
import org.apache.plc4x.java.spi.values.PlcList;

public class FirmataDriverContext
implements DriverContext {
    private final List<PlcSubscriptionRequest> subscriptions = new LinkedList<PlcSubscriptionRequest>();
    private final Map<Integer, PinMode> digitalPins = new HashMap<Integer, PinMode>();
    private final Map<Integer, PinMode> analogPins = new HashMap<Integer, PinMode>();

    public List<FirmataMessage> processWriteRequest(PlcWriteRequest writeRequest) {
        LinkedList<FirmataMessage> messages = new LinkedList<FirmataMessage>();
        for (String fieldName : writeRequest.getFieldNames()) {
            PlcList plcList;
            if (!(writeRequest.getField(fieldName) instanceof FirmataFieldDigital)) {
                throw new PlcRuntimeException("Writing only supported for digital pins");
            }
            FirmataFieldDigital digitalField = (FirmataFieldDigital)writeRequest.getField(fieldName);
            PlcValue plcValue = writeRequest.getPlcValue(fieldName);
            if (digitalField.getNumberOfElements() > 1 && plcValue.isList() && (plcList = (PlcList)plcValue).getList().size() != digitalField.getNumberOfElements()) {
                throw new PlcRuntimeException("Required " + digitalField.getNumberOfElements() + " but got " + plcList.getList().size());
            }
            for (int i = 0; i < digitalField.getNumberOfElements(); ++i) {
                int pin = digitalField.getAddress() + i;
                if (!this.digitalPins.containsKey(pin)) {
                    this.digitalPins.put(pin, PinMode.PinModeOutput);
                    messages.add(new FirmataMessageCommand(new FirmataCommandSetPinMode((byte)pin, PinMode.PinModeOutput, false), false));
                } else if (!this.digitalPins.get(pin).equals((Object)PinMode.PinModeOutput)) {
                    throw new PlcRuntimeException("Pin " + pin + " already configured as " + this.digitalPins.get(pin).name());
                }
                messages.add(new FirmataMessageCommand(new FirmataCommandSetDigitalPinValue((short)pin, plcValue.getIndex(i).getBoolean(), false), false));
            }
        }
        return messages;
    }

    public List<FirmataMessage> processSubscriptionRequest(PlcSubscriptionRequest subscriptionRequest) {
        HashMap<Integer, PinMode> requestDigitalFieldPinModes = new HashMap<Integer, PinMode>();
        HashMap<Integer, PinMode> requestAnalogFieldPinModes = new HashMap<Integer, PinMode>();
        for (String string : subscriptionRequest.getFieldNames()) {
            PlcSubscriptionField field = subscriptionRequest.getField(string);
            DefaultPlcSubscriptionField subscriptionField = (DefaultPlcSubscriptionField)field;
            if (subscriptionField.getPlcField() instanceof FirmataFieldDigital) {
                PinMode fieldPinMode;
                FirmataFieldDigital fieldDigital = (FirmataFieldDigital)subscriptionField.getPlcField();
                PinMode pinMode = fieldPinMode = fieldDigital.getPinMode() != null ? fieldDigital.getPinMode() : PinMode.PinModeInput;
                if (!fieldPinMode.equals((Object)PinMode.PinModeInput) && !fieldPinMode.equals((Object)PinMode.PinModePullup)) {
                    throw new PlcInvalidFieldException("Subscription field must be of type 'INPUT' (default) or 'PULLUP'");
                }
                for (int pin = fieldDigital.getAddress(); pin < fieldDigital.getAddress() + fieldDigital.getNumberOfElements(); ++pin) {
                    requestDigitalFieldPinModes.put(pin, fieldPinMode);
                }
                continue;
            }
            if (subscriptionField.getPlcField() instanceof FirmataFieldAnalog) {
                FirmataFieldAnalog fieldAnalog = (FirmataFieldAnalog)subscriptionField.getPlcField();
                for (int pin = fieldAnalog.getAddress(); pin < fieldAnalog.getAddress() + fieldAnalog.getNumberOfElements(); ++pin) {
                    requestAnalogFieldPinModes.put(pin, PinMode.PinModeInput);
                }
                continue;
            }
            throw new PlcRuntimeException("Unsupported field type " + field.getClass().getSimpleName());
        }
        for (Map.Entry entry : requestDigitalFieldPinModes.entrySet()) {
            int pin = (Integer)entry.getKey();
            PinMode pinMode = (PinMode)((Object)entry.getValue());
            if (!this.digitalPins.containsKey(pin)) continue;
            if (!this.digitalPins.get(pin).equals((Object)pinMode)) {
                throw new PlcInvalidFieldException(String.format("Error setting digital pin to mode %s, pin is already set to mode %s", pinMode.toString(), this.digitalPins.get(pin).toString()));
            }
            requestDigitalFieldPinModes.remove(pin);
        }
        for (Map.Entry entry : requestAnalogFieldPinModes.entrySet()) {
            int pin = (Integer)entry.getKey();
            if (!this.analogPins.containsKey(pin)) continue;
            requestAnalogFieldPinModes.remove(pin);
        }
        this.subscriptions.add(subscriptionRequest);
        LinkedList<FirmataMessage> messages = new LinkedList<FirmataMessage>();
        for (Map.Entry entry : requestDigitalFieldPinModes.entrySet()) {
            int pin = (Integer)entry.getKey();
            PinMode pinMode = (PinMode)((Object)entry.getValue());
            messages.add(new FirmataMessageCommand(new FirmataCommandSetPinMode((byte)pin, pinMode, false), false));
            messages.add(new FirmataMessageSubscribeDigitalPinValue((byte)pin, true, false));
        }
        for (Map.Entry entry : requestAnalogFieldPinModes.entrySet()) {
            int pin = (Integer)entry.getKey();
            messages.add(new FirmataMessageSubscribeAnalogPinValue((byte)pin, true, false));
        }
        return messages;
    }
}

