/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite.field;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.firmata.readwrite.field.FirmataFieldAnalog;
import org.apache.plc4x.java.firmata.readwrite.field.FirmataFieldDigital;

public abstract class FirmataField
implements PlcField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?<address>\\d+)(\\[(?<quantity>\\d+)])?");
    private final int address;
    private final int quantity;

    public static FirmataField of(String fieldString) {
        Matcher matcher = FirmataFieldAnalog.ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            return FirmataFieldAnalog.of(fieldString);
        }
        matcher = FirmataFieldDigital.ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            return FirmataFieldDigital.of(fieldString);
        }
        throw new PlcInvalidFieldException("Unable to parse address: " + fieldString);
    }

    protected FirmataField(int address, Integer quantity) {
        this.address = address;
        int n = this.quantity = quantity != null ? quantity : 1;
        if (this.quantity <= 0) {
            throw new IllegalArgumentException("quantity must be greater then zero. Was " + this.quantity);
        }
    }

    public int getAddress() {
        return this.address;
    }

    public int getNumberOfElements() {
        return this.quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FirmataField)) {
            return false;
        }
        FirmataField that = (FirmataField)o;
        return this.address == that.address;
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public String toString() {
        return "FirmataField{address=" + this.address + "quantity=" + this.quantity + '}';
    }
}

