/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip;

import io.netty.buffer.ByteBuf;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.knxnetip.configuration.KnxNetIpConfiguration;
import org.apache.plc4x.java.knxnetip.context.KnxNetIpDriverContext;
import org.apache.plc4x.java.knxnetip.field.KnxNetIpField;
import org.apache.plc4x.java.knxnetip.field.KnxNetIpFieldHandler;
import org.apache.plc4x.java.knxnetip.protocol.KnxNetIpProtocolLogic;
import org.apache.plc4x.java.knxnetip.readwrite.KnxNetIpMessage;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleFieldOptimizer;
import org.apache.plc4x.java.spi.values.IEC61131ValueHandler;

public class KnxNetIpDriver
extends GeneratedDriverBase<KnxNetIpMessage> {
    public static final int KNXNET_IP_PORT = 3671;

    public String getProtocolCode() {
        return "knxnet-ip";
    }

    public String getProtocolName() {
        return "KNXNet/IP";
    }

    protected String getDefaultTransport() {
        return "udp";
    }

    protected boolean canRead() {
        return false;
    }

    protected boolean canWrite() {
        return true;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return KnxNetIpConfiguration.class;
    }

    protected BaseOptimizer getOptimizer() {
        return new SingleFieldOptimizer();
    }

    protected PlcFieldHandler getFieldHandler() {
        return new KnxNetIpFieldHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new IEC61131ValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return true;
    }

    protected ProtocolStackConfigurer<KnxNetIpMessage> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(KnxNetIpMessage.class, KnxNetIpMessage::staticParse).withProtocol(KnxNetIpProtocolLogic.class).withDriverContext(KnxNetIpDriverContext.class).withPacketSizeEstimator(PacketSizeEstimator.class).build();
    }

    public KnxNetIpField prepareField(String query) {
        return KnxNetIpField.of(query);
    }

    public static class PacketSizeEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 6) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 4);
            }
            return -1;
        }
    }
}

