/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AccessLevel {
    Level0(0, "system manufacturer", true),
    Level1(1, "product manufacturer", true),
    Level2(2, "configuration", true),
    Level3(3, "end-user", false),
    Level15(15, "read access", false);

    private static final Map<Byte, AccessLevel> map;
    private byte value;
    private String purpose;
    private boolean needsAuthentication;

    private AccessLevel(byte value, String purpose, boolean needsAuthentication) {
        this.value = value;
        this.purpose = purpose;
        this.needsAuthentication = needsAuthentication;
    }

    public byte getValue() {
        return this.value;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public static AccessLevel firstEnumForFieldPurpose(String fieldValue) {
        for (AccessLevel _val : AccessLevel.values()) {
            if (_val.getPurpose() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<AccessLevel> enumsForFieldPurpose(String fieldValue) {
        ArrayList<AccessLevel> _values = new ArrayList<AccessLevel>();
        for (AccessLevel _val : AccessLevel.values()) {
            if (_val.getPurpose() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public boolean getNeedsAuthentication() {
        return this.needsAuthentication;
    }

    public static AccessLevel firstEnumForFieldNeedsAuthentication(boolean fieldValue) {
        for (AccessLevel _val : AccessLevel.values()) {
            if (_val.getNeedsAuthentication() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<AccessLevel> enumsForFieldNeedsAuthentication(boolean fieldValue) {
        ArrayList<AccessLevel> _values = new ArrayList<AccessLevel>();
        for (AccessLevel _val : AccessLevel.values()) {
            if (_val.getNeedsAuthentication() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static AccessLevel enumForValue(byte value) {
        return map.get(value);
    }

    public static Boolean isDefined(byte value) {
        return map.containsKey(value);
    }

    static {
        map = new HashMap<Byte, AccessLevel>();
        for (AccessLevel value : AccessLevel.values()) {
            map.put(value.getValue(), value);
        }
    }
}

