/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.knxnetip.readwrite.ApduData;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ApduDataMemoryRead
extends ApduData
implements Message {
    protected final short numBytes;
    protected final int address;
    protected final Short dataLength;

    @Override
    public Byte getApciType() {
        return (byte)8;
    }

    public ApduDataMemoryRead(short numBytes, int address, Short dataLength) {
        super(dataLength);
        this.numBytes = numBytes;
        this.address = address;
        this.dataLength = dataLength;
    }

    public short getNumBytes() {
        return this.numBytes;
    }

    public int getAddress() {
        return this.address;
    }

    @Override
    protected void serializeApduDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("ApduDataMemoryRead", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"numBytes", (Object)this.numBytes, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)6), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"address", (Object)this.address, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ApduDataMemoryRead", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ApduDataMemoryRead _value = this;
        lengthInBits += 6;
        return lengthInBits += 16;
    }

    public static ApduDataMemoryReadBuilder staticParseBuilder(ReadBuffer readBuffer, Short dataLength) throws ParseException {
        readBuffer.pullContext("ApduDataMemoryRead", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        short numBytes = (Short)FieldReaderFactory.readSimpleField((String)"numBytes", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)6), (WithReaderArgs[])new WithReaderArgs[0]);
        int address = (Integer)FieldReaderFactory.readSimpleField((String)"address", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ApduDataMemoryRead", new WithReaderArgs[0]);
        return new ApduDataMemoryReadBuilder(numBytes, address, dataLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApduDataMemoryRead)) {
            return false;
        }
        ApduDataMemoryRead that = (ApduDataMemoryRead)o;
        return this.getNumBytes() == that.getNumBytes() && this.getAddress() == that.getAddress() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNumBytes(), this.getAddress());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ApduDataMemoryReadBuilder
    implements ApduData.ApduDataBuilder {
        private final short numBytes;
        private final int address;
        private final Short dataLength;

        public ApduDataMemoryReadBuilder(short numBytes, int address, Short dataLength) {
            this.numBytes = numBytes;
            this.address = address;
            this.dataLength = dataLength;
        }

        @Override
        public ApduDataMemoryRead build(Short dataLength) {
            ApduDataMemoryRead apduDataMemoryRead = new ApduDataMemoryRead(this.numBytes, this.address, dataLength);
            return apduDataMemoryRead;
        }
    }
}

