/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.utils;

import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class KnxHelper {
    public static float bytesToF16(ReadBuffer io) {
        try {
            boolean negative = io.readBit();
            long exponent = io.readUnsignedLong(4);
            long mantissa = io.readUnsignedLong(11);
            return (float)((double)(negative ? -1 : 1) * (0.01 * (double)mantissa) * Math.pow(2.0, exponent));
        }
        catch (ParseException e) {
            throw new PlcRuntimeException("Error parsing F16 value", (Throwable)e);
        }
    }

    public static void f16toBytes(WriteBuffer io, Object param) {
        if (!(param instanceof Float)) {
            throw new PlcRuntimeException("Invalid datatype");
        }
        try {
            float value = ((Float)param).floatValue();
            boolean negative = value < 0.0f;
            int exponent = Math.getExponent(value);
            double mantissa = (double)value / Math.pow(2.0, exponent);
            String mantissaString = Double.toString(mantissa);
            int mantissaInteger = Integer.parseInt(mantissaString.substring(mantissaString.indexOf(46)));
            io.writeBit(negative);
            io.writeUnsignedInt(4, exponent + 15);
            io.writeUnsignedInt(11, mantissaInteger);
        }
        catch (SerializationException e) {
            throw new PlcRuntimeException("Error serializing F16 value", (Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        byte[] bytes = Hex.decodeHex((String)"0C65");
        ReadBufferByteBased io = new ReadBufferByteBased(bytes);
        double v = KnxHelper.bytesToF16((ReadBuffer)io);
        System.out.println(v);
    }
}

