/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.sampling;

import java.nio.ByteOrder;
import org.apache.pulsar.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.memory.NativeMemory;
import org.apache.pulsar.shade.com.yahoo.sketches.Family;
import org.apache.pulsar.shade.com.yahoo.sketches.ResizeFactor;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.Util;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int LG_RESIZE_FACTOR_BITS = 6;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int FLAGS_BYTE = 3;
    static final int RESERVOIR_SIZE_SHORT = 4;
    static final int RESERVOIR_SIZE_INT = 4;
    static final int SERDE_ID_SHORT = 6;
    static final int ITEMS_SEEN_BYTE = 8;
    static final int EMPTY_FLAG_MASK = 4;
    static final int SER_VER = 2;
    static final boolean NATIVE_ORDER_IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private PreambleUtil() {
    }

    public static String preambleToString(byte[] byteArr) {
        NativeMemory mem = new NativeMemory(byteArr);
        return PreambleUtil.preambleToString(mem);
    }

    public static String preambleToString(Memory mem) {
        int preLongs = PreambleUtil.getAndCheckPreLongs(mem);
        long pre0 = mem.getLong(0L);
        ResizeFactor rf = ResizeFactor.getRF(PreambleUtil.extractResizeFactor(pre0));
        int serVer = PreambleUtil.extractSerVer(pre0);
        Family family = Family.idToFamily(PreambleUtil.extractFamilyID(pre0));
        int flags = PreambleUtil.extractFlags(pre0);
        String flagsStr = Util.zeroPad(Integer.toBinaryString(flags), 8) + ", " + flags;
        String nativeOrder = ByteOrder.nativeOrder().toString();
        boolean isEmpty = (flags & 4) > 0;
        int resSize = PreambleUtil.extractReservoirSize(pre0);
        long itemsSeen = 0L;
        if (!isEmpty) {
            long pre1 = mem.getLong(8L);
            itemsSeen = PreambleUtil.extractItemsSeenCount(pre1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS).append("### SKETCH PREAMBLE SUMMARY:").append(Util.LS).append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS).append("Byte  0: ResizeFactor         : ").append(rf.toString()).append(Util.LS).append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS).append("Byte  2: Family               : ").append(family.toString()).append(Util.LS).append("Byte  3: Flags Field          : ").append(flagsStr).append(Util.LS).append("  (Native Byte Order)         : ").append(nativeOrder).append(Util.LS).append("  EMPTY                       : ").append(isEmpty).append(Util.LS).append("Bytes  4-7: Reservoir Size    : ").append(resSize).append("\t(").append(Util.LS);
        if (!isEmpty) {
            sb.append("Bytes 8-13: Items Seen      : ").append(itemsSeen).append(Util.LS);
        }
        sb.append("Preamble Bytes                : ").append(preLongs << 3).append(Util.LS);
        sb.append("### END SKETCH PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }

    static int extractPreLongs(long long0) {
        long mask = 63L;
        return (int)(long0 & 0x3FL);
    }

    static int extractResizeFactor(long long0) {
        int shift = 6;
        long mask = 3L;
        return (int)(long0 >>> 6 & 3L);
    }

    static int extractSerVer(long long0) {
        int shift = 8;
        long mask = 255L;
        return (int)(long0 >>> 8 & 0xFFL);
    }

    static int extractFamilyID(long long0) {
        int shift = 16;
        long mask = 255L;
        return (int)(long0 >>> 16 & 0xFFL);
    }

    static int extractFlags(long long0) {
        int shift = 24;
        long mask = 255L;
        return (int)(long0 >>> 24 & 0xFFL);
    }

    static short extractEncodedReservoirSize(long long0) {
        int shift = 32;
        long mask = 65535L;
        return (short)(long0 >>> 32 & 0xFFFFL);
    }

    static int extractReservoirSize(long long0) {
        int shift = 32;
        long mask = 0xFFFFFFFFL;
        return (int)(long0 >>> 32 & 0xFFFFFFFFL);
    }

    static int extractMaxK(long long0) {
        return PreambleUtil.extractReservoirSize(long0);
    }

    @Deprecated
    static short extractSerDeId(long long0) {
        int shift = 48;
        long mask = 65535L;
        return (short)(long0 >>> 48 & 0xFFFFL);
    }

    static long extractItemsSeenCount(long long1) {
        long mask = 0xFFFFFFFFFFFFL;
        return long1 & 0xFFFFFFFFFFFFL;
    }

    static long insertPreLongs(int preLongs, long long0) {
        long mask = 63L;
        return (long)preLongs & 0x3FL | 0xFFFFFFFFFFFFFFC0L & long0;
    }

    static long insertResizeFactor(int rf, long long0) {
        int shift = 6;
        long mask = 3L;
        return ((long)rf & 3L) << 6 | 0xFFFFFFFFFFFFFF3FL & long0;
    }

    static long insertSerVer(int serVer, long long0) {
        int shift = 8;
        long mask = 255L;
        return ((long)serVer & 0xFFL) << 8 | 0xFFFFFFFFFFFF00FFL & long0;
    }

    static long insertFamilyID(int familyID, long long0) {
        int shift = 16;
        long mask = 255L;
        return ((long)familyID & 0xFFL) << 16 | 0xFFFFFFFFFF00FFFFL & long0;
    }

    static long insertFlags(int flags, long long0) {
        int shift = 24;
        long mask = 255L;
        return ((long)flags & 0xFFL) << 24 | 0xFFFFFFFF00FFFFFFL & long0;
    }

    static long insertReservoirSize(int reservoirSize, long long0) {
        int shift = 32;
        long mask = 0xFFFFFFFFL;
        return ((long)reservoirSize & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL & long0;
    }

    static long insertMaxK(int reservoirSize, long long0) {
        return PreambleUtil.insertReservoirSize(reservoirSize, long0);
    }

    @Deprecated
    static long insertSerDeId(int serDeId, long long0) {
        int shift = 48;
        long mask = 65535L;
        return ((long)serDeId & 0xFFFFL) << 48 | 0xFFFFFFFFFFFFL & long0;
    }

    static long insertItemsSeenCount(long totalSeen, long long1) {
        long mask = 0xFFFFFFFFFFFFL;
        return totalSeen & 0xFFFFFFFFFFFFL | 0xFFFF000000000000L & long1;
    }

    static int getAndCheckPreLongs(Memory mem) {
        long pre0;
        int preLongs;
        int required;
        long cap = mem.getCapacity();
        if (cap < 8L) {
            PreambleUtil.throwNotBigEnough(cap, 8);
        }
        if (cap < (long)(required = Math.max((preLongs = PreambleUtil.extractPreLongs(pre0 = mem.getLong(0L))) << 3, 8))) {
            PreambleUtil.throwNotBigEnough(cap, required);
        }
        return preLongs;
    }

    private static void throwNotBigEnough(long cap, int required) {
        throw new SketchesArgumentException("Possible Corruption: Size of byte array or Memory not large enough: Size: " + cap + ", Required: " + required);
    }
}

