/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode.berkeleydb;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.HighAvailabilityMessages;
import org.apache.qpid.server.logging.subjects.BDBHAVirtualHostNodeLogSubject;
import org.apache.qpid.server.logging.subjects.GroupLogSubject;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.store.berkeleydb.replication.ReplicatedEnvironmentFacade;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.virtualhostnode.berkeleydb.BDBHARemoteReplicationNode;
import org.apache.qpid.server.virtualhostnode.berkeleydb.BDBHAVirtualHostNode;
import org.apache.qpid.server.virtualhostnode.berkeleydb.NodeRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDBHARemoteReplicationNodeImpl
extends AbstractConfiguredObject<BDBHARemoteReplicationNodeImpl>
implements BDBHARemoteReplicationNode<BDBHARemoteReplicationNodeImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDBHARemoteReplicationNodeImpl.class);
    private final ReplicatedEnvironmentFacade _replicatedEnvironmentFacade;
    private final String _address;
    private final Broker<?> _broker;
    private volatile Date _joinTime;
    private volatile long _lastTransactionId;
    @ManagedAttributeField(afterSet="afterSetRole")
    private volatile NodeRole _role;
    private final boolean _isMonitor;
    private BDBHAVirtualHostNodeLogSubject _virtualHostNodeLogSubject;
    private GroupLogSubject _groupLogSubject;
    private volatile NodeRole _lastKnownRole;
    private volatile boolean _nodeLeft = false;

    public BDBHARemoteReplicationNodeImpl(BDBHAVirtualHostNode<?> virtualHostNode, Map<String, Object> attributes, ReplicatedEnvironmentFacade replicatedEnvironmentFacade) {
        super(virtualHostNode, attributes);
        this._broker = (Broker)virtualHostNode.getParent();
        this._address = (String)attributes.get("address");
        this._replicatedEnvironmentFacade = replicatedEnvironmentFacade;
        this.setRole(NodeRole.UNREACHABLE);
        this._isMonitor = (Boolean)attributes.get("monitor");
    }

    @Override
    public String getGroupName() {
        return this._replicatedEnvironmentFacade.getGroupName();
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    @Override
    public NodeRole getRole() {
        return this._lastKnownRole;
    }

    @Override
    public Date getJoinTime() {
        return this._joinTime;
    }

    @Override
    public long getLastKnownReplicationTransactionId() {
        return this._lastTransactionId;
    }

    @Override
    public boolean isMonitor() {
        return this._isMonitor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + ", name=" + this.getName() + ", address=" + this.getAddress() + ", state=" + this.getState() + ", role=" + (Object)((Object)this.getRole()) + "]";
    }

    protected ListenableFuture<Void> onDelete() {
        if (!this._nodeLeft) {
            SettableFuture future = SettableFuture.create();
            String nodeName = this.getName();
            try {
                this._replicatedEnvironmentFacade.removeNodeFromGroup(nodeName);
                this.getEventLogger().message((LogSubject)this._virtualHostNodeLogSubject, HighAvailabilityMessages.DELETED());
                future.set(null);
            }
            catch (RuntimeException e) {
                future.setException((Throwable)e);
            }
            return future;
        }
        return super.onDelete();
    }

    protected void afterSetRole() {
        try {
            String nodeName = this.getName();
            this.getEventLogger().message((LogSubject)this._groupLogSubject, HighAvailabilityMessages.TRANSFER_MASTER((String)this.getName(), (String)this.getAddress()));
            this._replicatedEnvironmentFacade.transferMasterAsynchronously(nodeName).get(100L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Transfer master did not complete within 100ms. Node may still be elected master at a later time.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof ServerScopedRuntimeException) {
                throw (ServerScopedRuntimeException)cause;
            }
            throw new ConnectionScopedRuntimeException("Unexpected exception on master transfer: " + cause.getMessage(), cause);
        }
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        if (changedAttributes.contains("role")) {
            NodeRole currentRole = this.getRole();
            if (NodeRole.REPLICA != currentRole) {
                throw new IllegalArgumentException("Cannot transfer mastership when not in replica role. Current role " + (Object)((Object)currentRole));
            }
            NodeRole newRole = (NodeRole)((Object)((BDBHARemoteReplicationNode)proxyForValidation).getAttribute("role"));
            if (NodeRole.MASTER != newRole) {
                throw new IllegalArgumentException("Changing role to other value then " + (Object)((Object)NodeRole.MASTER) + " is unsupported");
            }
        }
        if (changedAttributes.contains("joinTime")) {
            throw new IllegalArgumentException("Cannot change derived attribute joinTime");
        }
        if (changedAttributes.contains("lastKnownReplicationTransactionId")) {
            throw new IllegalArgumentException("Cannot change derived attribute lastKnownReplicationTransactionId");
        }
    }

    void setRole(NodeRole role) {
        this._lastKnownRole = role;
        this._role = role;
        this.updateModelStateFromRole(role);
    }

    void setJoinTime(long joinTime) {
        this._joinTime = new Date(joinTime);
    }

    void setLastTransactionId(long lastTransactionId) {
        this._lastTransactionId = lastTransactionId;
    }

    private void updateModelStateFromRole(NodeRole role) {
        State currentState = this.getState();
        if (currentState == State.DELETED) {
            return;
        }
        boolean isActive = NodeRole.MASTER == role || NodeRole.REPLICA == role;
        this.setState(isActive ? State.ACTIVE : State.UNAVAILABLE);
    }

    public void onValidate() {
        super.onValidate();
        this._virtualHostNodeLogSubject = new BDBHAVirtualHostNodeLogSubject(this.getGroupName(), this.getName());
        this._groupLogSubject = new GroupLogSubject(this.getGroupName());
    }

    private EventLogger getEventLogger() {
        return this._broker.getEventLogger();
    }

    void setNodeLeft(boolean nodeLeft) {
        this._nodeLeft = nodeLeft;
    }

    protected ListenableFuture<Void> deleteNoChecks() {
        return super.deleteNoChecks();
    }
}

