/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.instrumentation.transformer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.instrumentation.metadata.AutomatedFieldDescription;
import org.apache.qpid.server.instrumentation.metadata.MethodDescription;
import org.apache.qpid.server.instrumentation.transformer.AbstractQpidTransformer;
import org.apache.qpid.server.instrumentation.transformer.QpidTransformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredObjectTypeRegistryTransformer<T extends AutomatedFieldDescription>
extends AbstractQpidTransformer<T>
implements QpidTransformer<T> {
    private static final String CLASS_NAME = "org.apache.qpid.server.model.ConfiguredObjectTypeRegistry$AutomatedField";
    private static final String INTERNAL_CLASS_NAME = "org/apache/qpid/server/model/ConfiguredObjectTypeRegistry$AutomatedField";
    private static final String DESC_CONSTRUCTOR = String.format("(%s%s%s)V", ConfiguredObjectTypeRegistryTransformer.referenceName(FIELD), ConfiguredObjectTypeRegistryTransformer.referenceName(METHOD), ConfiguredObjectTypeRegistryTransformer.referenceName(METHOD));
    private static final String PRESETTING_ACTION = "_preSettingAction";
    private static final String POSTSETTING_ACTION = "_postSettingAction";
    private static final String PRESETTING_SIGNATURE = "_preSettingSignature";
    private static final String POSTSETTING_SIGNATURE = "_postSettingSignature";
    private static final String PRESETTING_HASHCODE = "_preSettingHashcode";
    private static final String POSTSETTING_HASHCODE = "_postSettingHashcode";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredObjectTypeRegistryTransformer.class);
    private final List<T> _fields;

    public ConfiguredObjectTypeRegistryTransformer(List<T> fields) {
        this._fields = new ArrayList<T>(fields);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<T> getMemberDescriptions() {
        return new ArrayList<T>(this._fields);
    }

    @Override
    public ClassVisitor getTransformer(ClassVisitor cv) {
        return new Transformer(cv, this.getMemberDescriptions());
    }

    private class SetTransformer
    extends MethodVisitor {
        private final MethodVisitor _target;
        private final List<MethodDescription> _beforeSetMethods;
        private final List<MethodDescription> _afterSetMethods;
        private final List<MethodDescription> _allMethods;

        private SetTransformer(MethodVisitor delegate, List<MethodDescription> beforeSetMethods, List<MethodDescription> afterSetMethods, List<MethodDescription> allMethods) {
            super(589824, null);
            this._target = delegate;
            this._afterSetMethods = afterSetMethods;
            this._beforeSetMethods = beforeSetMethods;
            this._allMethods = allMethods;
        }

        public void visitCode() {
            this._target.visitCode();
            this.visitSettingAssociatedAction(ConfiguredObjectTypeRegistryTransformer.PRESETTING_ACTION, this._beforeSetMethods, ConfiguredObjectTypeRegistryTransformer.PRESETTING_HASHCODE, ConfiguredObjectTypeRegistryTransformer.PRESETTING_SIGNATURE);
            this._target.visitVarInsn(25, 0);
            this._target.visitFieldInsn(180, ConfiguredObjectTypeRegistryTransformer.INTERNAL_CLASS_NAME, "_field", AbstractQpidTransformer.referenceName(AbstractQpidTransformer.FIELD));
            this._target.visitVarInsn(25, 1);
            this._target.visitVarInsn(25, 2);
            this._target.visitMethodInsn(182, AbstractQpidTransformer.FIELD, "set", AbstractQpidTransformer.DESC_SET, AbstractQpidTransformer.FALSE.booleanValue());
            this.visitSettingAssociatedAction(ConfiguredObjectTypeRegistryTransformer.POSTSETTING_ACTION, this._afterSetMethods, ConfiguredObjectTypeRegistryTransformer.POSTSETTING_HASHCODE, ConfiguredObjectTypeRegistryTransformer.POSTSETTING_SIGNATURE);
            this._target.visitInsn(177);
            this._target.visitMaxs(0, 0);
            this._target.visitEnd();
        }

        private void visitSettingAssociatedAction(String action, List<MethodDescription> methods, String hashcode, String signature) {
            Label outer = new Label();
            this._target.visitLabel(outer);
            this._target.visitVarInsn(25, 0);
            this._target.visitFieldInsn(180, ConfiguredObjectTypeRegistryTransformer.INTERNAL_CLASS_NAME, action, AbstractQpidTransformer.referenceName(AbstractQpidTransformer.METHOD));
            Label outerPostSetting = new Label();
            this._target.visitJumpInsn(198, outerPostSetting);
            Label innerPostSetting = new Label();
            this._target.visitLabel(innerPostSetting);
            this.call(this._target, this._allMethods, methods, hashcode, signature, outerPostSetting);
            this._target.visitInsn(87);
            this._target.visitLabel(outerPostSetting);
            this._target.visitFrame(3, 0, null, 0, null);
        }

        private void call(MethodVisitor mv, List<MethodDescription> allMethods, List<MethodDescription> methods, String hashcodeVariable, String signatureVariable, Label label) {
            boolean configuredObjectIndex = true;
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, ConfiguredObjectTypeRegistryTransformer.INTERNAL_CLASS_NAME, hashcodeVariable, "I");
            mv.visitVarInsn(54, 7);
            int signatureIndex = 7;
            Map<String, AbstractQpidTransformer.AttributeStackAddress> stackMap = ConfiguredObjectTypeRegistryTransformer.this.createAttributesStackMap(methods);
            int[] hashes = new int[stackMap.size()];
            Label[] switchJumpLabels = new Label[stackMap.size()];
            ConfiguredObjectTypeRegistryTransformer.this.fillHashesAndLabels(stackMap, hashes, switchJumpLabels);
            Label switchLabel = new Label();
            mv.visitVarInsn(21, 7);
            mv.visitLookupSwitchInsn(switchLabel, hashes, switchJumpLabels);
            for (int i = 0; i < allMethods.size(); ++i) {
                MethodDescription method = allMethods.get(i);
                if (!methods.contains(method)) continue;
                mv.visitLabel(stackMap.get(method.getSignature()).getLabel());
                mv.visitFrame(3, 0, null, 0, null);
                mv.visitFieldInsn(178, ConfiguredObjectTypeRegistryTransformer.INTERNAL_CLASS_NAME, "MH_" + i, AbstractQpidTransformer.referenceName(AbstractQpidTransformer.METHOD_HANDLE));
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, method.getDeclaringClass());
                mv.visitMethodInsn(182, AbstractQpidTransformer.METHOD_HANDLE, "invokeExact", AbstractQpidTransformer.sig(method), AbstractQpidTransformer.FALSE.booleanValue());
                mv.visitJumpInsn(167, label);
            }
            mv.visitLabel(switchLabel);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, ConfiguredObjectTypeRegistryTransformer.INTERNAL_CLASS_NAME, signatureVariable, AbstractQpidTransformer.referenceName(AbstractQpidTransformer.STRING));
            mv.visitVarInsn(58, 3);
            mv.visitTypeInsn(187, "org/apache/qpid/server/util/ServerScopedRuntimeException");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)"Failed to call automated field callback %s");
            mv.visitInsn(4);
            mv.visitTypeInsn(189, AbstractQpidTransformer.OBJECT);
            mv.visitInsn(89);
            mv.visitInsn(3);
            mv.visitVarInsn(25, 3);
            mv.visitInsn(83);
            mv.visitMethodInsn(184, AbstractQpidTransformer.STRING, "format", AbstractQpidTransformer.DESC_FORMAT, AbstractQpidTransformer.FALSE.booleanValue());
            mv.visitMethodInsn(183, "org/apache/qpid/server/util/ServerScopedRuntimeException", "<init>", AbstractQpidTransformer.DESC_EXCEPTION1, AbstractQpidTransformer.FALSE.booleanValue());
            mv.visitInsn(191);
        }
    }

    private static class ConstructorTransformer
    extends MethodVisitor {
        private ConstructorTransformer(MethodVisitor delegate) {
            super(589824, delegate);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                int argIndex = 2;
                this.initSettingAssociatedAction(argIndex, ConfiguredObjectTypeRegistryTransformer.PRESETTING_ACTION, ConfiguredObjectTypeRegistryTransformer.PRESETTING_SIGNATURE, ConfiguredObjectTypeRegistryTransformer.PRESETTING_HASHCODE);
                this.mv.visitFrame(0, 4, new Object[]{ConfiguredObjectTypeRegistryTransformer.INTERNAL_CLASS_NAME, AbstractQpidTransformer.FIELD, AbstractQpidTransformer.referenceName(AbstractQpidTransformer.METHOD), AbstractQpidTransformer.referenceName(AbstractQpidTransformer.METHOD)}, 0, new Object[0]);
                argIndex = 3;
                this.initSettingAssociatedAction(argIndex, ConfiguredObjectTypeRegistryTransformer.POSTSETTING_ACTION, ConfiguredObjectTypeRegistryTransformer.POSTSETTING_SIGNATURE, ConfiguredObjectTypeRegistryTransformer.POSTSETTING_HASHCODE);
                this.mv.visitFrame(3, 0, null, 0, null);
            }
            super.visitInsn(opcode);
        }

        private void initSettingAssociatedAction(int argIndex, String action, String signature, String hashcode) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, ConfiguredObjectTypeRegistryTransformer.INTERNAL_CLASS_NAME, action, AbstractQpidTransformer.referenceName(AbstractQpidTransformer.METHOD));
            Label outerPostSetting = new Label();
            this.mv.visitJumpInsn(198, outerPostSetting);
            Label innerPostSetting = new Label();
            this.mv.visitLabel(innerPostSetting);
            AbstractQpidTransformer.generateSignature(this.mv, argIndex, ConfiguredObjectTypeRegistryTransformer.INTERNAL_CLASS_NAME, signature);
            Label postSetting = new Label();
            this.mv.visitLabel(postSetting);
            AbstractQpidTransformer.generateHashCode(this.mv, ConfiguredObjectTypeRegistryTransformer.INTERNAL_CLASS_NAME, signature, hashcode);
            this.mv.visitLabel(outerPostSetting);
        }
    }

    private class Transformer
    extends ClassVisitor {
        private final List<MethodDescription> _beforeSetMethods;
        private final List<MethodDescription> _afterSetMethods;
        private final List<MethodDescription> _allMethods;

        private Transformer(ClassVisitor cv, List<T> fields) {
            super(589824, cv);
            this._beforeSetMethods = fields.stream().map(AutomatedFieldDescription::getBeforeSet).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            this._afterSetMethods = fields.stream().map(AutomatedFieldDescription::getAfterSet).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            this._allMethods = Stream.concat(this._beforeSetMethods.stream(), this._afterSetMethods.stream()).collect(Collectors.toList());
        }

        public void visitEnd() {
            int size = this._allMethods.size();
            ConfiguredObjectTypeRegistryTransformer.this.visitMethodHandleFields(size, (ClassWriter)this.cv);
            int access = 2;
            this.visitField(2, ConfiguredObjectTypeRegistryTransformer.PRESETTING_SIGNATURE, AbstractQpidTransformer.referenceName(AbstractQpidTransformer.STRING), null, null).visitEnd();
            this.visitField(2, ConfiguredObjectTypeRegistryTransformer.POSTSETTING_SIGNATURE, AbstractQpidTransformer.referenceName(AbstractQpidTransformer.STRING), null, null).visitEnd();
            this.visitField(2, ConfiguredObjectTypeRegistryTransformer.PRESETTING_HASHCODE, "I", null, null).visitEnd();
            this.visitField(2, ConfiguredObjectTypeRegistryTransformer.POSTSETTING_HASHCODE, "I", null, null).visitEnd();
            ConfiguredObjectTypeRegistryTransformer.this.visitStaticInitializer(this._allMethods, ConfiguredObjectTypeRegistryTransformer.INTERNAL_CLASS_NAME, ConfiguredObjectTypeRegistryTransformer.CLASS_NAME, (ClassWriter)this.cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (name.equals("<init>") && desc.equals(DESC_CONSTRUCTOR)) {
                mv = new ConstructorTransformer(mv);
            }
            if ("set".equals(name) && "(Lorg/apache/qpid/server/model/ConfiguredObject;Ljava/lang/Object;)V".equals(desc)) {
                mv = new SetTransformer(mv, this._beforeSetMethods, this._afterSetMethods, this._allMethods);
            }
            return mv;
        }
    }
}

