/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Objects;
import javax.security.auth.Subject;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;

@FunctionalInterface
public interface RulePredicate {
    public boolean matches(LegacyOperation var1, ObjectProperties var2, Subject var3);

    default public RulePredicate and(RulePredicate other) {
        if (other instanceof Any) {
            return this;
        }
        if (other instanceof None) {
            return other;
        }
        Objects.requireNonNull(other);
        return (operation, objectProperties, subject) -> this.matches(operation, objectProperties, subject) && other.matches(operation, objectProperties, subject);
    }

    default public RulePredicate or(RulePredicate other) {
        if (other instanceof Any) {
            return other;
        }
        if (other instanceof None) {
            return this;
        }
        Objects.requireNonNull(other);
        return (operation, objectProperties, subject) -> this.matches(operation, objectProperties, subject) || other.matches(operation, objectProperties, subject);
    }

    default public boolean matchesAny() {
        return false;
    }

    public static RulePredicate any() {
        return Any.INSTANCE;
    }

    public static RulePredicate none() {
        return None.INSTANCE;
    }

    public static final class None
    implements RulePredicate {
        static final RulePredicate INSTANCE = new None();

        private None() {
        }

        @Override
        public boolean matches(LegacyOperation operation, ObjectProperties objectProperties, Subject subject) {
            return false;
        }

        @Override
        public RulePredicate and(RulePredicate other) {
            return this;
        }

        @Override
        public RulePredicate or(RulePredicate other) {
            return other;
        }
    }

    public static final class Any
    implements RulePredicate {
        static final RulePredicate INSTANCE = new Any();

        private Any() {
        }

        @Override
        public boolean matches(LegacyOperation operation, ObjectProperties objectProperties, Subject subject) {
            return true;
        }

        @Override
        public RulePredicate and(RulePredicate other) {
            return other;
        }

        @Override
        public RulePredicate or(RulePredicate other) {
            return this;
        }

        @Override
        public boolean matchesAny() {
            return true;
        }
    }
}

