/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.protocol.v0_10.transport.Struct;
import org.apache.qpid.server.protocol.v0_10.transport.Type;
import org.apache.qpid.server.protocol.v0_10.transport.Xid;

public class EncoderUtils {
    private static final Map<Class<?>, Type> ENCODINGS = new HashMap();

    public static Type getEncodingType(Object value) {
        if (value == null) {
            return Type.VOID;
        }
        Class<?> klass = value.getClass();
        Type type = EncoderUtils.resolve(klass);
        if (type == null) {
            throw new IllegalArgumentException("unable to resolve type: " + klass + ", " + value);
        }
        return type;
    }

    public static int getStruct32Length(Struct s) {
        if (s == null) {
            return 4;
        }
        int len = 0;
        len += 4;
        len += 2;
        return len += s.getEncodedLength();
    }

    public static int getArrayLength(List<Object> value) {
        int len = 0;
        len += 4;
        if (value != null && !value.isEmpty()) {
            ++len;
            len += 4;
            Type type = EncoderUtils.getEncodingType(value.get(0));
            for (Object v : value) {
                len += EncoderUtils.getTypeLength(type, v);
            }
        }
        return len;
    }

    public static int getListLength(List<Object> value) {
        int len = 0;
        len += 4;
        if (value != null && !value.isEmpty()) {
            len += 4;
            for (Object v : value) {
                Type type = EncoderUtils.getEncodingType(v);
                ++len;
                len += EncoderUtils.getTypeLength(type, v);
            }
        }
        return len;
    }

    public static int getStr8Length(String s) {
        if (s == null) {
            return 1;
        }
        int length = s.getBytes(StandardCharsets.UTF_8).length;
        if (length > 255) {
            throw new IllegalArgumentException(String.format("String too long (%d) for str8", length));
        }
        return 1 + length;
    }

    public static int getStr16Length(String s) {
        if (s == null) {
            return 2;
        }
        int length = s.getBytes(StandardCharsets.UTF_8).length;
        if (length > 65535) {
            throw new IllegalArgumentException(String.format("String too long (%d) for str16", length));
        }
        return 2 + length;
    }

    public static int getVbin16Length(byte[] bytes) {
        if (bytes == null) {
            return 2;
        }
        return 2 + bytes.length;
    }

    public static int getStructLength(int type, Struct s) {
        int width;
        int len = 0;
        if (s == null) {
            s = Struct.create(type);
        }
        if ((width = s.getSizeWidth()) > 0) {
            switch (width) {
                case 1: 
                case 2: 
                case 4: {
                    len += width;
                    break;
                }
                default: {
                    throw new IllegalStateException("illegal width: " + width);
                }
            }
        }
        if (type > 0) {
            len += 2;
        }
        return len += s.getEncodedLength();
    }

    public static int getMapLength(Map<String, Object> map) {
        int len = 0;
        len += 4;
        if (map != null) {
            len += 4;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                len += EncoderUtils.getStr8Length(key);
                ++len;
                Type type = EncoderUtils.getEncodingType(value);
                len += EncoderUtils.getTypeLength(type, value);
            }
        }
        return len;
    }

    private static Type resolve(Class klass) {
        Type type = ENCODINGS.get(klass);
        if (type != null) {
            return type;
        }
        Class sup = klass.getSuperclass();
        if (sup != null && (type = EncoderUtils.resolve(klass.getSuperclass())) != null) {
            return type;
        }
        for (Class<?> iface : klass.getInterfaces()) {
            type = EncoderUtils.resolve(iface);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private static int getTypeLength(Type t, Object value) {
        switch (t) {
            case VOID: {
                return 0;
            }
            case BIN8: 
            case UINT8: 
            case INT8: 
            case CHAR: 
            case BOOLEAN: {
                return 1;
            }
            case BIN16: 
            case UINT16: 
            case INT16: {
                return 2;
            }
            case BIN32: 
            case UINT32: 
            case CHAR_UTF32: 
            case INT32: 
            case FLOAT: {
                return 4;
            }
            case BIN64: 
            case UINT64: 
            case INT64: 
            case DATETIME: 
            case DOUBLE: {
                return 8;
            }
            case UUID: {
                return 16;
            }
            case STR8: {
                return EncoderUtils.getStr8Length((String)value);
            }
            case STR16: {
                return EncoderUtils.getStr16Length((String)value);
            }
            case STR8_LATIN: 
            case STR8_UTF16: 
            case STR16_LATIN: 
            case STR16_UTF16: {
                String str = (String)value;
                return t.getWidth() + (str == null ? 0 : str.getBytes(StandardCharsets.UTF_8).length);
            }
            case MAP: {
                return EncoderUtils.getMapLength((Map)value);
            }
            case LIST: {
                return EncoderUtils.getListLength((List)value);
            }
            case ARRAY: {
                return EncoderUtils.getArrayLength((List)value);
            }
            case STRUCT32: {
                return EncoderUtils.getStruct32Length((Struct)value);
            }
            case BIN40: 
            case DEC32: 
            case BIN72: 
            case DEC64: {
                return t.getWidth() + (value == null ? 0 : ((byte[])value).length);
            }
        }
        if (!(value instanceof byte[])) {
            throw new IllegalArgumentException("Expecting byte array was " + (Serializable)(value == null ? "null" : value.getClass()));
        }
        return t.getWidth() + (value == null ? 0 : ((byte[])value).length);
    }

    public static boolean isEncodable(Object value) {
        block9: {
            block8: {
                try {
                    EncoderUtils.getEncodingType(value);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                if (!(value instanceof Map)) break block8;
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object key = entry.getKey();
                    if (key instanceof String) {
                        String string = (String)key;
                        if (string.length() > 255) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    if (EncoderUtils.isEncodable(entry.getValue())) continue;
                    return false;
                }
                break block9;
            }
            if (!(value instanceof Collection)) break block9;
            Collection collection = (Collection)value;
            int index = 0;
            for (Object o : collection) {
                if (!EncoderUtils.isEncodable(o)) {
                    return false;
                }
                ++index;
            }
        }
        return true;
    }

    static {
        ENCODINGS.put(Boolean.class, Type.BOOLEAN);
        ENCODINGS.put(String.class, Type.STR16);
        ENCODINGS.put(Long.class, Type.INT64);
        ENCODINGS.put(Integer.class, Type.INT32);
        ENCODINGS.put(Short.class, Type.INT16);
        ENCODINGS.put(Byte.class, Type.INT8);
        ENCODINGS.put(Map.class, Type.MAP);
        ENCODINGS.put(List.class, Type.LIST);
        ENCODINGS.put(Float.class, Type.FLOAT);
        ENCODINGS.put(Double.class, Type.DOUBLE);
        ENCODINGS.put(Character.class, Type.CHAR);
        ENCODINGS.put(byte[].class, Type.VBIN32);
        ENCODINGS.put(UUID.class, Type.UUID);
        ENCODINGS.put(Xid.class, Type.STRUCT32);
    }
}

