/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.protocol.v0_8.CreditRestorer;
import org.apache.qpid.server.protocol.v0_8.MessageConsumerAssociation;
import org.apache.qpid.server.protocol.v0_8.UnacknowledgedMessageMap;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

class UnacknowledgedMessageMapImpl
implements UnacknowledgedMessageMap {
    private final Map<Long, MessageConsumerAssociationImpl> _map;
    private volatile int _size;
    private final CreditRestorer _creditRestorer;

    UnacknowledgedMessageMapImpl(int prefetchLimit, CreditRestorer creditRestorer) {
        this._map = new LinkedHashMap<Long, MessageConsumerAssociationImpl>(prefetchLimit);
        this._creditRestorer = creditRestorer;
    }

    @Override
    public void collect(long deliveryTag, boolean multiple, Map<Long, MessageConsumerAssociation> msgs) {
        if (multiple) {
            this.collect(deliveryTag, msgs);
        } else {
            MessageConsumerAssociation messageConsumerAssociation = this._map.get(deliveryTag);
            if (messageConsumerAssociation != null) {
                msgs.put(deliveryTag, messageConsumerAssociation);
            }
        }
    }

    private void remove(Collection<Long> msgs) {
        for (Long deliveryTag : msgs) {
            this.remove(deliveryTag, true);
        }
    }

    @Override
    public MessageConsumerAssociation remove(long deliveryTag, boolean restoreCredit) {
        MessageConsumerAssociationImpl entry = this._map.remove(deliveryTag);
        if (entry != null) {
            --this._size;
            if (restoreCredit && entry.isUsesCredit()) {
                this._creditRestorer.restoreCredit(entry.getConsumer().getTarget(), 1, entry.getSize());
            }
        }
        return entry;
    }

    @Override
    public void visit(UnacknowledgedMessageMap.Visitor visitor) {
        for (Map.Entry<Long, MessageConsumerAssociationImpl> entry : this._map.entrySet()) {
            visitor.callback(entry.getKey(), entry.getValue());
        }
        visitor.visitComplete();
    }

    @Override
    public void add(long deliveryTag, MessageInstance message, MessageInstanceConsumer consumer, boolean usesCredit) {
        if (this._map.put(deliveryTag, new MessageConsumerAssociationImpl(message, consumer, usesCredit)) == null) {
            ++this._size;
        } else {
            throw new ConnectionScopedRuntimeException("Unexpected duplicate delivery tag created");
        }
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public MessageInstance get(long key) {
        MessageConsumerAssociation association = this._map.get(key);
        return association == null ? null : association.getMessageInstance();
    }

    @Override
    public Collection<MessageConsumerAssociation> acknowledge(long deliveryTag, boolean multiple) {
        if (multiple) {
            LinkedHashMap<Long, MessageConsumerAssociation> ackedMessageMap = new LinkedHashMap<Long, MessageConsumerAssociation>();
            this.collect(deliveryTag, multiple, ackedMessageMap);
            this.remove(ackedMessageMap.keySet());
            ArrayList<MessageConsumerAssociation> acknowledged = new ArrayList<MessageConsumerAssociation>();
            for (MessageConsumerAssociation messageConsumerAssociation : ackedMessageMap.values()) {
                MessageInstance instance = messageConsumerAssociation.getMessageInstance();
                if (!instance.makeAcquisitionUnstealable(messageConsumerAssociation.getConsumer())) continue;
                acknowledged.add(messageConsumerAssociation);
            }
            return acknowledged;
        }
        MessageConsumerAssociation association = this.remove(deliveryTag, true);
        MessageInstance messageInstance = association.getMessageInstance();
        if (association != null && messageInstance.makeAcquisitionUnstealable(association.getConsumer())) {
            return Collections.singleton(association);
        }
        return Collections.emptySet();
    }

    private void collect(long key, Map<Long, MessageConsumerAssociation> msgs) {
        for (Map.Entry<Long, MessageConsumerAssociationImpl> entry : this._map.entrySet()) {
            msgs.put(entry.getKey(), entry.getValue());
            if (entry.getKey() != key) continue;
            break;
        }
    }

    private static final class MessageConsumerAssociationImpl
    implements MessageConsumerAssociation {
        private final MessageInstance _messageInstance;
        private final MessageInstanceConsumer _consumer;
        private final boolean _usesCredit;

        private MessageConsumerAssociationImpl(MessageInstance messageInstance, MessageInstanceConsumer consumer, boolean usesCredit) {
            this._messageInstance = messageInstance;
            this._consumer = consumer;
            this._usesCredit = usesCredit;
        }

        @Override
        public MessageInstance getMessageInstance() {
            return this._messageInstance;
        }

        @Override
        public MessageInstanceConsumer getConsumer() {
            return this._consumer;
        }

        @Override
        public long getSize() {
            return this._messageInstance.getMessage().getSize();
        }

        public boolean isUsesCredit() {
            return this._usesCredit;
        }
    }
}

