/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;
import org.apache.qpid.server.protocol.v0_8.transport.ServerChannelMethodProcessor;

public class ExchangeDeclareBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 40;
    public static final int METHOD_ID = 10;
    private final int _ticket;
    private final AMQShortString _exchange;
    private final AMQShortString _type;
    private final byte _bitfield0;
    private final FieldTable _arguments;

    public ExchangeDeclareBody(int ticket, AMQShortString exchange, AMQShortString type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, FieldTable arguments) {
        this._ticket = ticket;
        this._exchange = exchange;
        this._type = type;
        byte bitfield0 = 0;
        if (passive) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (durable) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (autoDelete) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        if (internal) {
            bitfield0 = (byte)(bitfield0 | 8);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 0x10);
        }
        this._bitfield0 = bitfield0;
        this._arguments = arguments;
    }

    @Override
    public int getClazz() {
        return 40;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getType() {
        return this._type;
    }

    public final boolean getPassive() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getDurable() {
        return (this._bitfield0 & 2) != 0;
    }

    public final boolean getAutoDelete() {
        return (this._bitfield0 & 4) != 0;
    }

    public final boolean getInternal() {
        return (this._bitfield0 & 8) != 0;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 0x10) != 0;
    }

    public final FieldTable getArguments() {
        return this._arguments;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._type);
        return size += this.getSizeOf(this._arguments);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._type);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeFieldTable(buffer, this._arguments);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchExchangeDeclare(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ExchangeDeclareBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("type=");
        buf.append(this.getType());
        buf.append(", ");
        buf.append("passive=");
        buf.append(this.getPassive());
        buf.append(", ");
        buf.append("durable=");
        buf.append(this.getDurable());
        buf.append(", ");
        buf.append("autoDelete=");
        buf.append(this.getAutoDelete());
        buf.append(", ");
        buf.append("internal=");
        buf.append(this.getInternal());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append(", ");
        buf.append("arguments=");
        buf.append(this.getArguments());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ServerChannelMethodProcessor dispatcher) throws AMQFrameDecodingException {
        int ticket = buffer.getUnsignedShort();
        AMQShortString exchange = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        AMQShortString type = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        byte bitfield = buffer.get();
        boolean passive = (bitfield & 1) == 1;
        boolean durable = (bitfield & 2) == 2;
        boolean autoDelete = (bitfield & 4) == 4;
        boolean internal = (bitfield & 8) == 8;
        boolean nowait = (bitfield & 0x10) == 16;
        FieldTable arguments = EncodingUtils.readFieldTable((QpidByteBuffer)buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveExchangeDeclare(exchange, type, passive, durable, autoDelete, internal, nowait, FieldTable.convertToDecodedFieldTable((FieldTable)arguments));
        }
        if (arguments != null) {
            arguments.dispose();
        }
    }
}

